% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polar_percentileMap.R
\name{percentileMapStatic}
\alias{percentileMapStatic}
\title{Percentile roses on a static ggmap}
\usage{
percentileMapStatic(
  data,
  pollutant = NULL,
  percentile = c(25, 50, 75, 90, 95),
  facet = NULL,
  limits = NULL,
  latitude = NULL,
  longitude = NULL,
  zoom = 13,
  ggmap = NULL,
  cols = "turbo",
  alpha = 1,
  key = FALSE,
  facet.nrow = NULL,
  d.icon = 150,
  d.fig = 3,
  ...
)
}
\arguments{
\item{data}{A data frame. The data frame must contain the data to plot the
directional analysis marker, which includes wind speed (\code{ws}), wind
direction (\code{wd}), and the column representing the concentration of a
pollutant. In addition, \code{data} must include a decimal latitude and
longitude.}

\item{pollutant}{The column name(s) of the pollutant(s) to plot. If multiple
pollutants are specified, they will each form part of a separate panel.}

\item{percentile}{The percentile value(s) to plot. Must be between 0–100. If
\code{percentile = NA} then only a mean line will be shown.}

\item{facet}{Used for splitting the input data into different panels, passed
to the \code{type} argument of \code{\link[openair:cutData]{openair::cutData()}}. \code{facet} cannot be used if
multiple \code{pollutant} columns have been provided.}

\item{limits}{By default, each individual polar marker has its own colour
scale. The \code{limits} argument will force all markers to use the same colour
scale. The limits are set in the form \code{c(lower, upper)}, so \code{limits = c(0, 100)} would force the plot limits to span 0-100.}

\item{latitude, longitude}{The decimal latitude/longitude. If not provided,
will be automatically inferred from data by looking for a column named
"lat"/"latitude" or "lon"/"lng"/"long"/"longitude" (case-insensitively).}

\item{zoom}{The zoom level to use for the basemap, passed to
\code{\link[ggmap:get_stamenmap]{ggmap::get_stamenmap()}}. Alternatively, the \code{ggmap} argument can be used
for more precise control of the basemap.}

\item{ggmap}{By default, \code{openairmaps} will try to estimate an appropriate
bounding box for the input data and then run \code{\link[ggmap:get_stamenmap]{ggmap::get_stamenmap()}} to
import a basemap. The \code{ggmap} argument allows users to provide their own
\code{ggmap} object to override this, which allows for alternative bounding
boxes, map types and colours.}

\item{cols}{The colours used for plotting. See \code{\link[openair:openColours]{openair::openColours()}} for
more information.}

\item{alpha}{The alpha transparency to use for the plotting surface (a value
between 0 and 1 with zero being fully transparent and 1 fully opaque).}

\item{key}{Should a key for each marker be drawn? Default is \code{FALSE}.}

\item{facet.nrow}{Passed to the \code{nrow} argument of \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}}.}

\item{d.icon}{The diameter of the plot on the map in pixels. This will affect
the size of the individual polar markers. Alternatively, a vector in the
form \code{c(width, height)} can be provided if a non-circular marker is
desired.}

\item{d.fig}{The diameter of the plots to be produced using \code{openair} in
inches. This will affect the resolution of the markers on the map.
Alternatively, a vector in the form \code{c(width, height)} can be provided if a
non-circular marker is desired.}

\item{...}{
  Arguments passed on to \code{\link[openair:percentileRose]{openair::percentileRose}}
  \describe{
    \item{\code{wd}}{Name of wind direction field.}
    \item{\code{type}}{\code{type} determines how the data are split i.e. conditioned,
and then plotted. The default is will produce a single plot using the
entire data. Type can be one of the built-in types as detailed in
\code{cutData} e.g. \dQuote{season}, \dQuote{year}, \dQuote{weekday} and so
on. For example, \code{type = "season"} will produce four plots --- one for
each season.

It is also possible to choose \code{type} as another variable in the data
frame. If that variable is numeric, then the data will be split into four
quantiles (if possible) and labelled accordingly. If type is an existing
character or factor variable, then those categories/levels will be used
directly. This offers great flexibility for understanding the variation of
different variables and how they depend on one another.

Type can be up length two e.g. \code{type = c("season", "weekday")} will
produce a 2x2 plot split by season and day of the week. Note, when two
types are provided the first forms the columns and the second the rows.}
    \item{\code{smooth}}{Should the wind direction data be smoothed using a cyclic
spline?}
    \item{\code{method}}{When \code{method = "default"} the supplied percentiles by wind
direction are calculated. When \code{method = "cpf"} the conditional
probability function (CPF) is plotted and a single (usually high)
percentile level is supplied. The CPF is defined as CPF = my/ny, where my
is the number of samples in the wind sector y with mixing ratios greater
than the \emph{overall} percentile concentration, and ny is the total
number of samples in the same wind sector (see Ashbaugh et al., 1985).}
    \item{\code{angle}}{Default angle of \dQuote{spokes} is when \code{smooth = FALSE}.}
    \item{\code{mean}}{Show the mean by wind direction as a line?}
    \item{\code{mean.lty}}{Line type for mean line.}
    \item{\code{mean.lwd}}{Line width for mean line.}
    \item{\code{mean.col}}{Line colour for mean line.}
    \item{\code{fill}}{Should the percentile intervals be filled (default) or should
lines be drawn (\code{fill = FALSE}).}
    \item{\code{intervals}}{User-supplied intervals for the scale e.g. \code{intervals =
c(0, 10, 30, 50)}}
    \item{\code{angle.scale}}{Sometimes the placement of the scale may interfere with an
interesting feature. The user can therefore set \code{angle.scale} to
any value between 0 and 360 degrees to mitigate such problems. For
example \code{angle.scale = 45} will draw the scale heading in a NE
direction.}
    \item{\code{auto.text}}{Either \code{TRUE} (default) or \code{FALSE}. If \code{TRUE}
titles and axis labels will automatically try and format pollutant names
and units properly e.g.  by subscripting the `2' in NO2.}
    \item{\code{key.header}}{Adds additional text/labels to the scale key. For example,
passing the options \code{key.header = "header", key.footer = "footer1"}
adds addition text above and below the scale key. These arguments are
passed to \code{drawOpenKey} via \code{quickText}, applying the
\code{auto.text} argument, to handle formatting.}
    \item{\code{key.footer}}{see \code{key.footer}.}
    \item{\code{key.position}}{Location where the scale key is to plotted. Allowed
arguments currently include \code{"top"}, \code{"right"}, \code{"bottom"}
and \code{"left"}.}
  }}
}
\value{
a \code{ggplot2} plot with a \code{ggmap} basemap
}
\description{
\code{\link[=percentileMapStatic]{percentileMapStatic()}} creates a \code{ggplot2} map using percentile roses as
markers. As this function returns a \code{ggplot2} object, further customisation
can be achieved using functions like \code{\link[ggplot2:theme]{ggplot2::theme()}} and
\code{\link[ggplot2:guides]{ggplot2::guides()}}.
}
\section{Further customisation using ggplot2}{


As the outputs of the static directional analysis functions are \code{ggplot2}
figures, further customisation is possible using functions such as
\code{\link[ggplot2:theme]{ggplot2::theme()}}, \code{\link[ggplot2:guides]{ggplot2::guides()}} and \code{\link[ggplot2:labs]{ggplot2::labs()}}.

If multiple pollutants are specified, subscripting (e.g., the "x" in "NOx")
is achieved using the \link[ggtext:ggtext]{ggtext} package. Therefore if you
choose to override the plot theme, it is recommended to use
\verb{[ggplot2::theme()]} and \verb{[ggtext::element_markdown()]} to define the
\code{strip.text} parameter.

When arguments like \code{limits}, \code{percentile} or \code{breaks} are defined, a
legend is automatically added to the figure. Legends can be removed using
\code{ggplot2::theme(legend.position = "none")}, or further customised using
\code{\link[ggplot2:guides]{ggplot2::guides()}} and either \code{color = ggplot2::guide_colourbar()} for
continuous legends or \code{fill = ggplot2::guide_legend()} for discrete
legends.
}

\seealso{
the original \code{\link[openair:percentileRose]{openair::percentileRose()}}

\code{\link[=percentileMap]{percentileMap()}} for the interactive \code{leaflet} equivalent of
\code{\link[=percentileMapStatic]{percentileMapStatic()}}

Other static directional analysis maps: 
\code{\link{annulusMapStatic}()},
\code{\link{diffMapStatic}()},
\code{\link{freqMapStatic}()},
\code{\link{polarMapStatic}()},
\code{\link{pollroseMapStatic}()},
\code{\link{windroseMapStatic}()}
}
\concept{static directional analysis maps}
