% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup_grass_environment.R
\name{setup_grass_environment}
\alias{setup_grass_environment}
\title{Setup 'GRASS' environment.}
\usage{
setup_grass_environment(dem, sites = NULL, epsg = NULL, proj4 = NULL)
}
\arguments{
\item{dem}{character; path to DEM.}

\item{sites}{character string or object; path to sites vector file (shape) 
or sp data object.}

\item{epsg}{number; EPSG code for the spatial reference to be used}

\item{proj4}{(optional) proj4 string; character string of projection arguments}
}
\value{
Nothing, the 'GRASS' mapset is set to PERMANENT,
projection is set to the one of the sites shape, to the proj4 string or to 
the epsg code provided, the extent of the region is set to the one of bounding
box of the dem.
}
\description{
This function sets the 'GRASS' mapset to PERMANENT and sets its projection and extension.
}
\note{
Either \code{sites}, \code{epsg} or \code{proj4} must be provided. Make
sure that all raster and vector files are in the same projection; it will be
overwritten without warning. A 'GRASS' session must be initiated before, see
\code{\link[rgrass7]{initGRASS}}.
}
\examples{
\donttest{
# Initiate GRASS session
if(.Platform$OS.type == "windows"){
  gisbase = "c:/Program Files/GRASS GIS 7.2.0"
  } else {
  gisbase = "/usr/lib/grass72/"
  }
initGRASS(gisBase = gisbase,
    home = tempdir(),
    override = TRUE)

# Load files into GRASS
dem_path <- system.file("extdata", "nc", "elev_ned_30m.tif", package = "openSTARS")
sites_path <- system.file("extdata", "nc", "sites_nc.shp", package = "openSTARS")
setup_grass_environment(dem = dem_path, sites = sites_path)
gmeta()
}
}
\author{
Mira Kattwinkel, \email{mira.kattwinkel@gmx.net}
}
