/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.util.Iterator;
import java.util.List;
import opennlp.tools.namefind.FeatureGeneratorAdapter;
import opennlp.tools.ngram.NGramModel;
import opennlp.tools.ngram.TokenList;

public class CharacterNgramFeatureGenerator
extends FeatureGeneratorAdapter {
    private final int minLength;
    private final int maxLength;

    public CharacterNgramFeatureGenerator(int minLength, int maxLength) {
        this.minLength = minLength;
        this.maxLength = maxLength;
    }

    public CharacterNgramFeatureGenerator() {
        this(2, 5);
    }

    public void createFeatures(List features, String[] tokens, int index, String[] preds) {
        NGramModel model = new NGramModel();
        model.add(tokens[index], this.minLength, this.maxLength);
        Iterator it = model.iterator();
        while (it.hasNext()) {
            TokenList tokenList = (TokenList)it.next();
            if (tokenList.size() <= 0) continue;
            features.add("ng=" + tokenList.getToken(0).getToken().toLowerCase());
        }
    }
}

