/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.util.ArrayList;
import java.util.List;
import opennlp.tools.namefind.AdaptiveFeatureGenerator;
import opennlp.tools.util.Cache;

public class CachedFeatureGenerator
implements AdaptiveFeatureGenerator {
    private final AdaptiveFeatureGenerator[] generators;
    private String[] prevTokens;
    private Cache contextsCache;
    private long numberOfCacheHits;
    private long numberOfCacheMisses;

    public CachedFeatureGenerator(AdaptiveFeatureGenerator[] generators) {
        this.generators = generators;
        this.contextsCache = new Cache(100);
    }

    public void createFeatures(List features, String[] tokens, int index, String[] previousOutcomes) {
        ArrayList cacheFeatures;
        if (tokens == this.prevTokens) {
            cacheFeatures = (ArrayList)this.contextsCache.get(new Integer(index));
            if (cacheFeatures != null) {
                ++this.numberOfCacheHits;
                features.addAll(cacheFeatures);
                return;
            }
        } else {
            this.contextsCache.clear();
            this.prevTokens = tokens;
        }
        cacheFeatures = new ArrayList();
        ++this.numberOfCacheMisses;
        for (int i = 0; i < this.generators.length; ++i) {
            this.generators[i].createFeatures(cacheFeatures, tokens, index, previousOutcomes);
        }
        this.contextsCache.put(new Integer(index), cacheFeatures);
        features.addAll(cacheFeatures);
    }

    public void updateAdaptiveData(String[] tokens, String[] outcomes) {
        for (int i = 0; i < this.generators.length; ++i) {
            this.generators[i].updateAdaptiveData(tokens, outcomes);
        }
    }

    public void clearAdaptiveData() {
        for (int i = 0; i < this.generators.length; ++i) {
            this.generators[i].clearAdaptiveData();
        }
    }

    public long getNumberOfCacheHits() {
        return this.numberOfCacheHits;
    }

    public long getNumberOfCacheMisses() {
        return this.numberOfCacheMisses;
    }

    public String toString() {
        return super.toString() + ": hits=" + this.numberOfCacheHits + " misses=" + this.numberOfCacheMisses + " hit%" + (this.numberOfCacheHits > 0L ? (double)this.numberOfCacheHits / (double)(this.numberOfCacheMisses + this.numberOfCacheHits) : 0.0);
    }
}

