/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.dictionary.serializer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import opennlp.tools.dictionary.serializer.Attributes;
import opennlp.tools.dictionary.serializer.Entry;
import opennlp.tools.dictionary.serializer.EntryInserter;
import opennlp.tools.ngram.Token;
import opennlp.tools.ngram.TokenList;
import opennlp.tools.util.InvalidFormatException;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLReaderFactory;

public class DictionarySerializer {
    private static final String CHARSET = "UTF-8";
    private static final String DICTIONARY_ELEMENT = "dictionary";
    private static final String ENTRY_ELEMENT = "entry";
    private static final String TOKEN_ELEMENT = "token";

    public static void create(InputStream in, EntryInserter inserter) throws IOException, InvalidFormatException {
        DictionaryContenthandler profileContentHandler = new DictionaryContenthandler(inserter);
        try {
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            xmlReader.setContentHandler(profileContentHandler);
            xmlReader.parse(new InputSource(new GZIPInputStream(in)));
        }
        catch (SAXException e) {
            throw new InvalidFormatException("The profile data stream hasan invalid format!", e);
        }
    }

    public static void serialize(OutputStream out, Iterator entries) throws IOException {
        TransformerHandler hd;
        GZIPOutputStream gzipOut = new GZIPOutputStream(out);
        StreamResult streamResult = new StreamResult(gzipOut);
        SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        try {
            hd = tf.newTransformerHandler();
        }
        catch (TransformerConfigurationException e1) {
            throw new AssertionError((Object)"The Tranformer configuration must be valid!");
        }
        Transformer serializer = hd.getTransformer();
        serializer.setOutputProperty("encoding", CHARSET);
        serializer.setOutputProperty("indent", "yes");
        hd.setResult(streamResult);
        try {
            hd.startDocument();
            hd.startElement("", "", DICTIONARY_ELEMENT, new AttributesImpl());
            while (entries.hasNext()) {
                Entry entry = (Entry)entries.next();
                DictionarySerializer.serializeEntry(hd, entry);
            }
            hd.endElement("", "", DICTIONARY_ELEMENT);
            hd.endDocument();
        }
        catch (SAXException e) {
            throw new IOException("There was an error during serialization!");
        }
        gzipOut.finish();
    }

    private static void serializeEntry(TransformerHandler hd, Entry entry) throws SAXException {
        AttributesImpl entryAttributes = new AttributesImpl();
        Iterator it = entry.getAttributes().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            entryAttributes.addAttribute("", "", key, "", entry.getAttributes().getValue(key));
        }
        hd.startElement("", "", ENTRY_ELEMENT, entryAttributes);
        TokenList tokens = entry.getTokens();
        Iterator it2 = tokens.iterator();
        while (it2.hasNext()) {
            hd.startElement("", "", TOKEN_ELEMENT, new AttributesImpl());
            Token token = (Token)it2.next();
            hd.characters(token.getToken().toCharArray(), 0, token.getToken().length());
            hd.endElement("", "", TOKEN_ELEMENT);
        }
        hd.endElement("", "", ENTRY_ELEMENT);
    }

    private static class DictionaryContenthandler
    implements ContentHandler {
        private EntryInserter mInserter;
        private boolean mIsInsideTokenElement;
        private List mTokenList = new LinkedList();
        private Attributes mAttributes;

        private DictionaryContenthandler(EntryInserter inserter) {
            this.mInserter = inserter;
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void startDocument() throws SAXException {
        }

        public void startElement(String uri, String localName, String qName, org.xml.sax.Attributes atts) throws SAXException {
            if (DictionarySerializer.ENTRY_ELEMENT.equals(localName)) {
                this.mAttributes = new Attributes();
                for (int i = 0; i < atts.getLength(); ++i) {
                    this.mAttributes.setValue(atts.getLocalName(i), atts.getValue(i));
                }
            } else if (DictionarySerializer.TOKEN_ELEMENT.equals(localName)) {
                this.mIsInsideTokenElement = true;
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.mIsInsideTokenElement) {
                this.mTokenList.add(Token.create(new String(ch, start, length)));
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (DictionarySerializer.ENTRY_ELEMENT.equals(localName)) {
                Token[] tokens = this.mTokenList.toArray(new Token[this.mTokenList.size()]);
                Entry entry = new Entry(new TokenList(tokens), this.mAttributes);
                try {
                    this.mInserter.insert(entry);
                }
                catch (InvalidFormatException e) {
                    throw new SAXException("Invalid dictionary format!");
                }
                this.mTokenList.clear();
                this.mAttributes = null;
            } else if (DictionarySerializer.TOKEN_ELEMENT.equals(localName)) {
                this.mIsInsideTokenElement = false;
            }
        }

        public void endDocument() throws SAXException {
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }
    }
}

