/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref;

import java.io.IOException;
import java.util.regex.Pattern;
import opennlp.tools.coref.DiscourseEntity;
import opennlp.tools.coref.mention.HeadFinder;
import opennlp.tools.coref.mention.Mention;
import opennlp.tools.coref.mention.MentionContext;
import opennlp.tools.coref.mention.MentionFinder;

public interface Linker {
    public static final String DESCRIPTOR = "desc";
    public static final String ISA = "isa";
    public static final String COMBINED_NPS = "cmbnd";
    public static final String NP = "np";
    public static final String PROPER_NOUN_MODIFIER = "pnmod";
    public static final String PRONOUN_MODIFIER = "np";
    public static final Pattern singularThirdPersonPronounPattern = Pattern.compile("^(he|she|it|him|her|his|hers|its|himself|herself|itself)$", 2);
    public static final Pattern pluralThirdPersonPronounPattern = Pattern.compile("^(they|their|theirs|them|themselves)$", 2);
    public static final Pattern speechPronounPattern = Pattern.compile("^(I|me|my|you|your|you|we|us|our|ours)$", 2);
    public static final Pattern malePronounPattern = Pattern.compile("^(he|him|his|himself)$", 2);
    public static final Pattern femalePronounPattern = Pattern.compile("^(she|her|hers|herself)$", 2);
    public static final Pattern neuterPronounPattern = Pattern.compile("^(it|its|itself)$", 2);
    public static final Pattern firstPersonPronounPattern = Pattern.compile("^(I|me|my|we|our|us|ours)$", 2);
    public static final Pattern secondPersonPronounPattern = Pattern.compile("^(you|your|yours)$", 2);
    public static final Pattern thirdPersonPronounPattern = Pattern.compile("^(he|she|it|him|her|his|hers|its|himself|herself|itself|they|their|theirs|them|themselves)$", 2);
    public static final Pattern singularPronounPattern = Pattern.compile("^(I|me|my|he|she|it|him|her|his|hers|its|himself|herself|itself)$", 2);
    public static final Pattern pluralPronounPattern = Pattern.compile("^(we|us|our|ours|they|their|theirs|them|themselves)$", 2);
    public static final Pattern honorificsPattern = Pattern.compile("[A-Z][a-z]+\\.$|^[A-Z][b-df-hj-np-tv-xz]+$");
    public static final Pattern designatorsPattern = Pattern.compile("[a-z]\\.$|^[A-Z][b-df-hj-np-tv-xz]+$|^Co(rp)?$");

    public void setEntities(Mention[] var1);

    public DiscourseEntity[] getEntities(Mention[] var1);

    public MentionContext[] constructMentionContexts(Mention[] var1);

    public void train() throws IOException;

    public MentionFinder getMentionFinder();

    public HeadFinder getHeadFinder();
}

