/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.parser;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import opennlp.maxent.DataStream;
import opennlp.maxent.Event;
import opennlp.maxent.EventStream;
import opennlp.maxent.PlainTextByLineDataStream;
import opennlp.tools.chunker.ChunkerContextGenerator;
import opennlp.tools.ngram.Dictionary;
import opennlp.tools.parser.BuildContextGenerator;
import opennlp.tools.parser.CheckContextGenerator;
import opennlp.tools.parser.ChunkContextGenerator;
import opennlp.tools.parser.EventTypeEnum;
import opennlp.tools.parser.HeadRules;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.ParserME;
import opennlp.tools.postag.DefaultPOSContextGenerator;
import opennlp.tools.postag.POSContextGenerator;

public class ParserEventStream
implements EventStream {
    private BuildContextGenerator bcg;
    private CheckContextGenerator kcg;
    private ChunkerContextGenerator ccg;
    private POSContextGenerator tcg;
    private DataStream data;
    private Event[] events;
    private int ei;
    private HeadRules rules;
    private Set punctSet;
    private EventTypeEnum etype;

    public ParserEventStream(DataStream d, HeadRules rules, EventTypeEnum etype, Dictionary dict) {
        if (etype == EventTypeEnum.BUILD) {
            this.bcg = new BuildContextGenerator(dict);
        } else if (etype == EventTypeEnum.CHECK) {
            this.kcg = new CheckContextGenerator();
        } else if (etype == EventTypeEnum.CHUNK) {
            this.ccg = new ChunkContextGenerator();
        } else if (etype == EventTypeEnum.TAG) {
            this.tcg = new DefaultPOSContextGenerator(dict);
        }
        this.rules = rules;
        this.punctSet = rules.getPunctuationTags();
        this.etype = etype;
        this.data = d;
        this.ei = 0;
        if (d.hasNext()) {
            this.addNewEvents();
        } else {
            this.events = new Event[0];
        }
    }

    public ParserEventStream(DataStream d, HeadRules rules, EventTypeEnum etype) {
        this(d, rules, etype, null);
    }

    public boolean hasNext() {
        return this.ei < this.events.length || this.data.hasNext();
    }

    public Event nextEvent() {
        if (this.ei == this.events.length) {
            this.addNewEvents();
            this.ei = 0;
        }
        return this.events[this.ei++];
    }

    private static void getInitialChunks(Parse p, List ichunks) {
        if (p.isPosTag()) {
            ichunks.add(p);
        } else {
            int ci;
            Parse[] kids = p.getChildren();
            boolean allKidsAreTags = true;
            int cl = kids.length;
            for (ci = 0; ci < cl; ++ci) {
                if (kids[ci].isPosTag()) continue;
                allKidsAreTags = false;
                break;
            }
            if (allKidsAreTags) {
                ichunks.add(p);
            } else {
                cl = kids.length;
                for (ci = 0; ci < cl; ++ci) {
                    ParserEventStream.getInitialChunks(kids[ci], ichunks);
                }
            }
        }
    }

    public static Parse[] getInitialChunks(Parse p) {
        ArrayList chunks = new ArrayList();
        ParserEventStream.getInitialChunks(p, chunks);
        return chunks.toArray(new Parse[chunks.size()]);
    }

    private boolean firstChild(Parse child, Parse parent) {
        return ParserME.collapsePunctuation(parent.getChildren(), this.punctSet)[0] == child;
    }

    private boolean lastChild(Parse child, Parse parent) {
        Parse[] kids = ParserME.collapsePunctuation(parent.getChildren(), this.punctSet);
        return kids[kids.length - 1] == child;
    }

    private void addNewEvents() {
        String parseStr = (String)this.data.nextToken();
        ArrayList newEvents = new ArrayList();
        Parse p = Parse.parseParse(parseStr);
        p.updateHeads(this.rules);
        Parse[] chunks = ParserEventStream.getInitialChunks(p);
        if (this.etype == EventTypeEnum.TAG) {
            this.addTagEvents(newEvents, chunks);
        } else if (this.etype == EventTypeEnum.CHUNK) {
            this.addChunkEvents(newEvents, chunks);
        } else {
            this.addParseEvents(newEvents, ParserME.collapsePunctuation(chunks, this.punctSet));
        }
        this.events = newEvents.toArray(new Event[newEvents.size()]);
    }

    public static Parse[] reduceChunks(Parse[] chunks, int ci, Parse parent) {
        Parse[] reducedChunks;
        int reduceStart;
        String type = parent.getType();
        int reduceEnd = ci;
        for (reduceStart = ci; reduceStart >= 0 && chunks[reduceStart].getParent() == parent; --reduceStart) {
        }
        ++reduceStart;
        if (!type.equals("TOP")) {
            int ri;
            reducedChunks = new Parse[chunks.length - (reduceEnd - reduceStart + 1) + 1];
            int rn = reduceStart;
            for (ri = 0; ri < rn; ++ri) {
                reducedChunks[ri] = chunks[ri];
            }
            reducedChunks[reduceStart] = parent;
            parent.setPrevPunctuation(chunks[reduceStart].getPreviousPunctuationSet());
            parent.setNextPunctuation(chunks[reduceEnd].getNextPunctuationSet());
            ri = reduceStart + 1;
            for (int rci = reduceEnd + 1; rci < chunks.length; ++rci) {
                reducedChunks[ri] = chunks[rci];
                ++ri;
            }
            ci = reduceStart - 1;
        } else {
            reducedChunks = new Parse[]{};
        }
        return reducedChunks;
    }

    private void addParseEvents(List parseEvents, Parse[] chunks) {
        for (int ci = 0; ci < chunks.length; ++ci) {
            int start;
            Parse c = chunks[ci];
            Parse parent = c.getParent();
            if (parent == null) continue;
            String type = parent.getType();
            String outcome = this.firstChild(c, parent) ? "S-" + type : "C-" + type;
            c.setLabel(outcome);
            if (this.etype == EventTypeEnum.BUILD) {
                parseEvents.add(new Event(outcome, this.bcg.getContext(chunks, ci)));
            }
            for (start = ci - 1; start >= 0 && chunks[start].getParent() == parent; --start) {
            }
            if (this.lastChild(c, parent)) {
                int reduceStart;
                if (this.etype == EventTypeEnum.CHECK) {
                    parseEvents.add(new Event("c", this.kcg.getContext(chunks, type, start + 1, ci)));
                }
                for (reduceStart = ci; reduceStart >= 0 && chunks[reduceStart].getParent() == parent; --reduceStart) {
                }
                chunks = ParserEventStream.reduceChunks(chunks, ci, parent);
                ci = ++reduceStart - 1;
                continue;
            }
            if (this.etype != EventTypeEnum.CHECK) continue;
            parseEvents.add(new Event("i", this.kcg.getContext(chunks, type, start + 1, ci)));
        }
    }

    private void addChunkEvents(List chunkEvents, Parse[] chunks) {
        ArrayList<String> toks = new ArrayList<String>();
        ArrayList<String> tags = new ArrayList<String>();
        ArrayList<String> preds = new ArrayList<String>();
        for (Parse c : chunks) {
            if (c.isPosTag()) {
                toks.add(c.toString());
                tags.add(c.getType());
                preds.add("O");
                continue;
            }
            boolean start = true;
            String ctype = c.getType();
            for (Parse tok : c.getChildren()) {
                toks.add(tok.toString());
                tags.add(tok.getType());
                if (start) {
                    preds.add("S-" + ctype);
                    start = false;
                    continue;
                }
                preds.add("C-" + ctype);
            }
        }
        int tl = toks.size();
        for (int ti = 0; ti < tl; ++ti) {
            chunkEvents.add(new Event((String)preds.get(ti), this.ccg.getContext(ti, toks.toArray(), tags.toArray(new String[tags.size()]), preds.toArray(new String[preds.size()]))));
        }
    }

    private void addTagEvents(List tagEvents, Parse[] chunks) {
        ArrayList<String> toks = new ArrayList<String>();
        ArrayList<String> preds = new ArrayList<String>();
        for (Parse c : chunks) {
            if (c.isPosTag()) {
                toks.add(c.toString());
                preds.add(c.getType());
                continue;
            }
            for (Parse tok : c.getChildren()) {
                toks.add(tok.toString());
                preds.add(tok.getType());
            }
        }
        int tl = toks.size();
        for (int ti = 0; ti < tl; ++ti) {
            tagEvents.add(new Event((String)preds.get(ti), this.tcg.getContext(ti, toks.toArray(), preds.toArray(new String[preds.size()]), null)));
        }
    }

    public static void main(String[] args) throws IOException {
        int ai;
        if (args.length == 0) {
            System.err.println("Usage ParserEventStream -[tag|chunk|build|check|fun] head_rules [dictionary] < parses");
            System.exit(1);
        }
        EventTypeEnum etype = null;
        boolean fun = false;
        for (ai = 0; ai < args.length && args[ai].startsWith("-"); ++ai) {
            if (args[ai].equals("-build")) {
                etype = EventTypeEnum.BUILD;
                continue;
            }
            if (args[ai].equals("-check")) {
                etype = EventTypeEnum.CHECK;
                continue;
            }
            if (args[ai].equals("-chunk")) {
                etype = EventTypeEnum.CHUNK;
                continue;
            }
            if (args[ai].equals("-tag")) {
                etype = EventTypeEnum.TAG;
                continue;
            }
            if (args[ai].equals("-fun")) {
                fun = true;
                continue;
            }
            System.err.println("Invalid option " + args[ai]);
            System.exit(1);
        }
        opennlp.tools.lang.english.HeadRules rules = new opennlp.tools.lang.english.HeadRules(args[ai++]);
        Dictionary dict = null;
        if (ai < args.length) {
            dict = new Dictionary(args[ai++]);
        }
        if (fun) {
            Parse.useFunctionTags(true);
        }
        ParserEventStream es = new ParserEventStream((DataStream)new PlainTextByLineDataStream((Reader)new InputStreamReader(System.in)), rules, etype, dict);
        while (es.hasNext()) {
            System.out.println(es.nextEvent());
        }
    }
}

