/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref.resolver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import opennlp.tools.coref.DiscourseEntity;
import opennlp.tools.coref.mention.MentionContext;
import opennlp.tools.coref.resolver.MaxentResolver;
import opennlp.tools.coref.resolver.NonReferentialResolver;
import opennlp.tools.coref.resolver.ResolverMode;

public class CommonNounResolver
extends MaxentResolver {
    public CommonNounResolver(String projectName, ResolverMode m) throws IOException {
        super(projectName, "cmodel", m, 80, true);
        this.showExclusions = false;
        this.preferFirstReferent = true;
    }

    public CommonNounResolver(String projectName, ResolverMode m, NonReferentialResolver nrr) throws IOException {
        super(projectName, "cmodel", m, 80, true, nrr);
        this.showExclusions = false;
        this.preferFirstReferent = true;
    }

    protected List getFeatures(MentionContext mention, DiscourseEntity entity) {
        ArrayList features = new ArrayList();
        features.addAll(super.getFeatures(mention, entity));
        if (entity != null) {
            features.addAll(CommonNounResolver.getContextFeatures(mention));
            features.addAll(this.getStringMatchFeatures(mention, entity));
        }
        return features;
    }

    public boolean canResolve(MentionContext mention) {
        String firstTok = mention.getFirstTokenText().toLowerCase();
        String firstTokTag = mention.getFirstToken().getSyntacticType();
        boolean rv = mention.getHeadTokenTag().equals("NN") && !this.definiteArticle(firstTok, firstTokTag);
        return rv;
    }

    protected boolean excluded(MentionContext ec, DiscourseEntity de) {
        if (super.excluded(ec, de)) {
            return true;
        }
        MentionContext cec = de.getLastExtent();
        return !this.canResolve(cec) || super.excluded(ec, de);
    }
}

