/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref.mention;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import opennlp.tools.coref.mention.AbstractParse;
import opennlp.tools.coref.mention.Parse;
import opennlp.tools.lang.english.NameFinder;
import opennlp.tools.util.Span;

public class DefaultParse
extends AbstractParse {
    private opennlp.tools.parser.Parse parse;
    private int sentenceNumber;
    private static Set entitySet = new HashSet<String>(Arrays.asList(NameFinder.NAME_TYPES));

    public DefaultParse(opennlp.tools.parser.Parse parse, int sentenceNumber) {
        this.parse = parse;
        this.sentenceNumber = sentenceNumber;
    }

    public int getSentenceNumber() {
        return this.sentenceNumber;
    }

    public List getNamedEntities() {
        ArrayList<opennlp.tools.parser.Parse> names = new ArrayList<opennlp.tools.parser.Parse>();
        LinkedList<opennlp.tools.parser.Parse> kids = new LinkedList<opennlp.tools.parser.Parse>(Arrays.asList(this.parse.getChildren()));
        while (kids.size() > 0) {
            opennlp.tools.parser.Parse p = (opennlp.tools.parser.Parse)kids.remove(0);
            if (entitySet.contains(p.getType())) {
                names.add(p);
                continue;
            }
            kids.addAll(Arrays.asList(p.getChildren()));
        }
        return this.createParses(names.toArray(new opennlp.tools.parser.Parse[names.size()]));
    }

    public List getChildren() {
        return this.createParses(this.parse.getChildren());
    }

    public List getSyntacticChildren() {
        ArrayList<opennlp.tools.parser.Parse> kids = new ArrayList<opennlp.tools.parser.Parse>(Arrays.asList(this.parse.getChildren()));
        for (int ci = 0; ci < kids.size(); ++ci) {
            opennlp.tools.parser.Parse kid = (opennlp.tools.parser.Parse)kids.get(ci);
            if (!entitySet.contains(kid.getType())) continue;
            kids.remove(ci);
            kids.addAll(ci, Arrays.asList(kid.getChildren()));
            --ci;
        }
        return this.createParses(kids.toArray(new opennlp.tools.parser.Parse[kids.size()]));
    }

    public List getTokens() {
        ArrayList<opennlp.tools.parser.Parse> tokens = new ArrayList<opennlp.tools.parser.Parse>();
        LinkedList<opennlp.tools.parser.Parse> kids = new LinkedList<opennlp.tools.parser.Parse>(Arrays.asList(this.parse.getChildren()));
        while (kids.size() > 0) {
            opennlp.tools.parser.Parse p = (opennlp.tools.parser.Parse)kids.remove(0);
            if (p.isPosTag()) {
                tokens.add(p);
                continue;
            }
            kids.addAll(0, Arrays.asList(p.getChildren()));
        }
        return this.createParses(tokens.toArray(new opennlp.tools.parser.Parse[tokens.size()]));
    }

    public String getSyntacticType() {
        if (entitySet.contains(this.parse.getType())) {
            return null;
        }
        return this.parse.getType();
    }

    private List createParses(opennlp.tools.parser.Parse[] parses) {
        ArrayList<DefaultParse> newParses = new ArrayList<DefaultParse>(parses.length);
        int pn = parses.length;
        for (int pi = 0; pi < pn; ++pi) {
            newParses.add(new DefaultParse(parses[pi], this.sentenceNumber));
        }
        return newParses;
    }

    public String getEntityType() {
        if (entitySet.contains(this.parse.getType())) {
            return this.parse.getType();
        }
        return null;
    }

    public boolean isParentNAC() {
        for (opennlp.tools.parser.Parse parent = this.parse.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.getType().equals("NAC")) continue;
            return true;
        }
        return false;
    }

    public Parse getParent() {
        opennlp.tools.parser.Parse parent = this.parse.getParent();
        if (parent == null) {
            return null;
        }
        return new DefaultParse(parent, this.sentenceNumber);
    }

    public boolean isNamedEntity() {
        return entitySet.contains(this.parse.getType());
    }

    public boolean isNounPhrase() {
        return this.parse.getType().equals("NP");
    }

    public boolean isSentence() {
        return this.parse.getType().equals("TOP");
    }

    public boolean isToken() {
        return this.parse.isPosTag();
    }

    public int getEntityId() {
        return -1;
    }

    public Span getSpan() {
        return this.parse.getSpan();
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        DefaultParse p = (DefaultParse)o;
        if (this.sentenceNumber < p.sentenceNumber) {
            return -1;
        }
        if (this.sentenceNumber > p.sentenceNumber) {
            return 1;
        }
        return this.parse.getSpan().compareTo(p.getSpan());
    }

    public String toString() {
        return this.parse.toString();
    }

    public Parse getPreviousToken() {
        opennlp.tools.parser.Parse parent = this.parse.getParent();
        opennlp.tools.parser.Parse node = this.parse;
        int index = -1;
        while (parent != null && index < 0) {
            index = parent.indexOf(node) - 1;
            if (index >= 0) continue;
            node = parent;
            parent = parent.getParent();
        }
        if (index < 0) {
            return null;
        }
        opennlp.tools.parser.Parse p = parent.getChildren()[index];
        while (!p.isPosTag()) {
            opennlp.tools.parser.Parse[] kids = p.getChildren();
            p = kids[kids.length - 1];
        }
        return new DefaultParse(p, this.sentenceNumber);
    }

    public Parse getNextToken() {
        opennlp.tools.parser.Parse parent;
        opennlp.tools.parser.Parse node = this.parse;
        int index = -1;
        for (parent = this.parse.getParent(); parent != null && (index = parent.indexOf(node) + 1) == parent.getChildCount(); parent = parent.getParent()) {
            node = parent;
        }
        if (parent == null) {
            return null;
        }
        opennlp.tools.parser.Parse p = parent.getChildren()[index];
        while (!p.isPosTag()) {
            p = p.getChildren()[0];
        }
        return new DefaultParse(p, this.sentenceNumber);
    }

    public boolean equals(Object o) {
        return this.parse == ((DefaultParse)o).parse;
    }

    public int hashCode() {
        return this.parse.hashCode();
    }

    public opennlp.tools.parser.Parse getParse() {
        return this.parse;
    }
}

