% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.datasource.r
\name{opal.tables}
\alias{opal.tables}
\title{Get tables of a datasource}
\usage{
opal.tables(opal, datasource, counts = FALSE, df = TRUE)
}
\arguments{
\item{opal}{Opal object.}

\item{datasource}{Name of the datasource.}

\item{counts}{Flag to get the number of variables and entities (default is FALSE).}

\item{df}{Return a data.frame (default is TRUE)}
}
\description{
Get tables of a datasource
}
\examples{
\donttest{
o <- opal.login('administrator','password','https://opal-demo.obiba.org')
opal.tables(o, 'datashield')
opal.logout(o)
}
}
\seealso{
Other datasource functions: \code{\link{opal.annotate}},
  \code{\link{opal.annotations}},
  \code{\link{opal.attribute_values}},
  \code{\link{opal.datasources}},
  \code{\link{opal.datasource}},
  \code{\link{opal.projects}}, \code{\link{opal.project}},
  \code{\link{opal.table}}, \code{\link{opal.valueset}},
  \code{\link{opal.variables}}, \code{\link{opal.variable}}
}
\concept{datasource functions}
