% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.assign.r
\name{opal.assign.data}
\alias{opal.assign.data}
\title{Data assignment}
\usage{
opal.assign.data(opal, symbol, value, async = FALSE)
}
\arguments{
\item{opal}{Opal object or list of opal objects.}

\item{symbol}{Name of the R symbol.}

\item{value}{The R object to assign (data.frame, vector).}

\item{async}{R script is executed asynchronously within the session (default is FALSE). If TRUE, the value returned is the ID of the command to look for (from Opal 2.1).}
}
\description{
Assign a R object to a R symbol in the current R session.
}
\examples{
\donttest{
o <- opal.login('administrator','password','https://opal-demo.obiba.org')
# push an arbitrary data frame to the R server
opal.assign.data(o, "D", mtcars)
# push an arbitrary vector to the R server
opal.assign.data(o, "C", mtcars$cyl)
# push a string
opal.assign.data(o, "S", "Hello!")
opal.logout(o)
}
}
\seealso{
Other assignment functions: \code{\link{opal.assign.script}},
  \code{\link{opal.assign.table.tibble}},
  \code{\link{opal.assign.table}},
  \code{\link{opal.assign}}
}
\concept{assignment functions}
