% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.admin.r
\name{oadmin.install_github}
\alias{oadmin.install_github}
\title{Install a package form GitHub}
\usage{
oadmin.install_github(opal, pkg, username = getOption("github.user"),
  ref = "master", auth_user = NULL, password = NULL)
}
\arguments{
\item{opal}{Opal object or list of opal objects.}

\item{pkg}{Package name.}

\item{username}{GitHub user name.}

\item{ref}{Desired git reference. Could be a commit, tag, or branch name. Defaults to "master".}

\item{auth_user}{Your github username if you're attempting to install a package hosted in a private repository (and your username is different to username).}

\item{password}{Your github password}
}
\description{
Install a package from a source repository on GitHub. Makes sure devtools package is available.
}
\examples{
\donttest{
o <- opal.login('administrator','password','https://opal-demo.obiba.org')
oadmin.install_github(o, 'opalr', 'obiba')
opal.logout(o)
}
}
\seealso{
Other administration functions: \code{\link{oadmin.install_devtools}},
  \code{\link{oadmin.install_package}},
  \code{\link{oadmin.installed_devtools}},
  \code{\link{oadmin.installed_packages}},
  \code{\link{oadmin.installed_package}},
  \code{\link{oadmin.package_description}},
  \code{\link{oadmin.remove_package}}
}
\concept{administration functions}
