% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aslt.R
\name{aslt}
\alias{aslt}
\alias{aslt.character}
\alias{aslt.POSIXct}
\alias{aslt.POSIXlt}
\alias{aslt.numeric}
\title{Convertion to POSIXlt}
\usage{
aslt(object, ...)

\method{aslt}{character}(object, tz = "GMT", ...)

\method{aslt}{POSIXct}(object, tz = NA, ...)

\method{aslt}{POSIXlt}(object, tz = NA, ...)

\method{aslt}{numeric}(object, ...)
}
\arguments{
\item{object}{The character, POSIXct, POSIClt, or numeric which is converted to POSIXct.}

\item{...}{Arguments to be passed to methods.}

\item{tz}{Timezone. If set, then the time zone will be changed of the object.}
}
\value{
An object of class POSIXlt
}
\description{
The argument is converted into POSIXlt with tz="GMT".
}
\section{Methods}{



    - aslt.character: Simply a wrapper for \code{as.POSIXlt}


    - aslt.POSIXct: Converts to POSIXct.


    - aslt.POSIXlt: Changes the time zone of the object if tz is given.


    - aslt.numeric: Converts from UNIX time in seconds to POSIXlt.
}

\examples{

# Create a POSIXlt with tz="GMT"
aslt("2019-01-01")
class(aslt("2019-01-01"))
aslt("2019-01-01 01:00:05")

# Convert between time zones
x <- aslt("2019-01-01", tz="CET")
aslt(x,tz="GMT")

# To seconds and back again
aslt(as.numeric(x, units="sec"))

}
