% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_planning_polygon.R
\name{get_planning_polygon}
\alias{get_planning_polygon}
\title{Get Planning Polygon for a Specific Point}
\usage{
get_planning_polygon(token, lat, lon, year = NULL, read = NULL)
}
\arguments{
\item{token}{User's API token. This can be retrieved using \code{\link{get_token}}}

\item{lat}{Latitude of location point}

\item{lon}{Longitude of location point}

\item{year}{Optional, check \href{https://docs.onemap.sg/#planning-area-query}{documentation} for valid options. Invalid requests will are ignored by the API.}

\item{read}{Optional, which package to use to read geojson object. For "sf" objects, specify \code{read = "sf"} and for "sp" objects use \code{read = "rgdal"}.}
}
\value{
If the parameter \code{read} is not specified, the function returns a raw JSON object a list containing the planning area name and a geojson string representing the polygon. \cr \cr
If \code{read = "sf"}, the function returns a 1 x 2 "sf" dataframe: "name" (name of planning area) and "geometry", which contains the simple feature. \cr \cr
If \code{read = "rgdal"}, the function returns a SpatialPolygonsDataFrame of "sp" class. The names of the planning area is recorded in the "name" column of the dataframe. \cr \cr
If an error occurs, the function returns NULL and a warning message is printed.
}
\description{
This function is a wrapper for the \href{https://docs.onemap.sg/#planning-area-query}{Planning Area Query API}. It returns the spatial polygon data matching the specified location point, either in raw format, as an sf or sp object.
}
\note{
If the user specifies a \code{read} method but does not have the corresponding package installed, the function will return the raw JSON and print a warning message.
}
\examples{
# returns raw JSON object
\dontrun{get_planning_polygon(token)}
\dontrun{get_planning_polygon(token, 2008)}

# returns dataframe of class "sf"
\dontrun{get_planning_polygon(token, read = "sf")}

# returns SpatialPolygonsDataFrame ("sp" object)
\dontrun{get_planning_polygon(token, read = "rgdal")}

# error: output is NULL, warning message shows status code
\dontrun{get_planning_polygon("invalid_token")}
\dontrun{get_planning_polygon(token, "invalidlat", "invalidlon")}
}
