% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpp_utils.R
\name{est_map_hmm_out}
\alias{est_map_hmm_out}
\title{C++ routine for multipoint analysis in outcrossing populations}
\usage{
est_map_hmm_out(
  geno,
  error,
  type,
  phase,
  rf.vec = NULL,
  verbose = TRUE,
  tol = 1e-06
)
}
\arguments{
\item{geno}{matrix of genotypes. Rows represent marker and columns
represent individuals.}

\item{type}{a vector indicating the type of marker. For more
information see \code{\link[onemap]{read_onemap}}}

\item{phase}{a vector indicating the linkage phases between
markers. For more information see
\code{\link[onemap]{make_seq}}}

\item{rf.vec}{a vector containing the recombination fraction
initial values}

\item{verbose}{If \code{TRUE}, print tracing information.}

\item{tol}{tolerance for the C routine, i.e., the value used to
evaluate convergence.}
}
\value{
a list containing the re-estimated vector of recombination
    fractions and the logarithm of the likelihood
}
\description{
It calls C++ routine that implements the methodology of Hidden
Markov Models (HMM) to construct multipoint linkage maps in
outcrossing species
}
\keyword{internal}
