% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_map.R
\name{draw_map}
\alias{draw_map}
\title{Draw a genetic map}
\usage{
draw_map(map.list, horizontal = FALSE, names = FALSE, grid = FALSE,
  cex.mrk = 1, cex.grp = 0.75)
}
\arguments{
\item{map.list}{a map, i.e. an object of class \code{sequence} with a
predefined order, linkage phases, recombination fraction and likelihood;
also it could be a list of maps.}

\item{horizontal}{if \code{TRUE}, indicates that the map should be plotted
horizontally. Default is \code{FALSE}}

\item{names}{if \code{TRUE}, displays the names of the markers. Default is
\code{FALSE}}

\item{grid}{if \code{TRUE}, displays a grid in the background. Default is
\code{FALSE}}

\item{cex.mrk}{the magnification to be used for markers.}

\item{cex.grp}{the magnification to be used for group axis annotation.}
}
\description{
Provides a simple draw of a genetic map.
}
\examples{

\dontrun{
 #outcross example
  data(onemap_example_out)
  twopt <- rf_2pts(onemap_example_out)
  lg<-group(make_seq(twopt, "all"))
  maps<-vector("list", lg$n.groups)
  for(i in 1:lg$n.groups)
     maps[[i]]<- make_seq(order_seq(input.seq= make_seq(lg,i),twopt.alg =
   "rcd"), "force")
  draw_map(maps, grid=TRUE)
  draw_map(maps, grid=TRUE, horizontal=TRUE)

  #F2 example
  data(onemap_example_f2)
  twopt<-rf_2pts(onemap_example_f2)
  lg<-group(make_seq(twopt, "all"))
  maps<-vector("list", lg$n.groups)
  for(i in 1:lg$n.groups)
     maps[[i]]<- make_seq(order_seq(input.seq= make_seq(lg,i),twopt.alg =
   "rcd"), "force")
  draw_map(maps, grid=TRUE)
  draw_map(maps, grid=TRUE, horizontal=TRUE)

}
}
\author{
Marcelo Mollinari, \email{mmollina@usp.br}
}
\keyword{rqtl}
