% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rf_graph_table.R
\name{rf_graph_table}
\alias{rf_graph_table}
\title{Plots pairwise recombination fractions and LOD Scores in a heatmap}
\usage{
rf_graph_table(input.seq, scale = 1, axis.cex = 1, main = NULL,
  inter = TRUE, mrk.names = FALSE, colorkey = TRUE)
}
\arguments{
\item{input.seq}{an object of class \code{sequence} with a predefined
order.}

\item{scale}{controls the plot size. If \code{inter == FALSE} this value is
not used.}

\item{axis.cex}{the magnification to be used for axis annotation.}

\item{main}{the title for no interactive plot, i.e. it is only used if
\code{inter == FALSE}.}

\item{inter}{logical. If \code{TRUE}, an interactive graphic is plotted.
Otherwise, a default graphic device is used.}

\item{mrk.names}{logical. If \code{TRUE}, displays the names of the markers.}

\item{colorkey}{logical. If \code{TRUE}, a colorkey is plotted
along horizontal axis, indicating recombination fraction, and
along vertical axis, indicating the LOD Score.}
}
\description{
Plots a matrix of pairwise recombination fractions (under the diagonal) and
LOD Scores (above the diagonal) using a color scale. Any value of the
matrix can be easily accessed using an interactive Tcl-Tk interface,
helping users to check for possible problems.
}
\details{
The color scale varies from red (small distances or big LODs) to dark blue.
When clicking on a cell, a dialog box is displayed with some information
about corresponding markers for that cell (line \eqn{\times} column). They are:
\eqn{i}) the name of the markers; \eqn{ii}) the number of
the markers on the data set; \eqn{iii}) the segregation types; \eqn{iv})
the recombination fraction between the markers and \eqn{v}) the LOD-Score
for each possible linkage phase calculated via two-point analysis. For
neighbor markers, the multipoint recombination fraction is printed;
otherwise, the two-point recombination fraction is printed. For markers of
type \code{D1} and \code{D2}, it is impossible to calculate recombination
fraction via two-point analysis and, therefore, the corresponding cell will
be empty. For cells on the diagonal of the matrix, the name, the number and
the type of the marker are printed, as well as the percentage of missing
data for that marker.
}
\examples{

\dontrun{
##outcross example
  data(example_out)
  twopt <- rf_2pts(example_out)
  all_mark <- make_seq(twopt,"all")
  groups <- group(all_mark)
  LG1 <- make_seq(groups,1)
  LG1.rcd <- rcd(LG1)
  rf_graph_table(LG1.rcd, inter=FALSE)


  ##Now, using interactive Tcl-Tk
  rf_graph_table(LG1.rcd, scale=2, inter=TRUE)

  ##F2 example
  data(onemap_example_f2)
  twopt <- rf_2pts(onemap_example_f2)
  all_mark <- make_seq(twopt,"all")
  groups <- group(all_mark)

  ##"pre-allocate" an empty list of length groups$n.groups (3, in this case)
  maps.list<-vector("list", groups$n.groups)

  for(i in 1:groups$n.groups){
    ##create linkage group i
    LG.cur <- make_seq(groups,i)
    ##ordering
    map.cur<-order_seq(LG.cur, subset.search = "sample")
    ##assign the map of the i-th group to the maps.list
    maps.list[[i]]<-make_seq(map.cur, "force")
  }
  ##Plot LOD/recombination fraction matrices for each group
  op <- par(mfrow = c(1, 3))
  for(i in 1:groups$n.groups)
    rf_graph_table(maps.list[[i]], axis.cex=.7, main=paste("Group", i),inter=FALSE)
  par(op)
}

}
\author{
Marcelo Mollinari, \email{mmollina@gmail.com}
}
\keyword{utilities}
