% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classCdmReference.R
\name{cdmSource}
\alias{cdmSource}
\title{Get the cdmSource of an object.}
\usage{
cdmSource(x, cdm = lifecycle::deprecated())
}
\arguments{
\item{x}{Object to obtain the cdmSource.}

\item{cdm}{Deprecated, use x please.}
}
\value{
A cdm_source object.
}
\description{
Get the cdmSource of an object.
}
\examples{
\donttest{
library(omopgenerics)
library(dplyr, warn.conflicts = FALSE)

cdm <- cdmFromTables(
  tables = list(
    "person" = tibble(
      person_id = c(1, 2, 3), gender_concept_id = 0, year_of_birth = 1990,
      race_concept_id = 0, ethnicity_concept_id = 0
    ),
    "observation_period" = tibble(
      observation_period_id = 1:3, person_id = 1:3,
      observation_period_start_date = as.Date("2000-01-01"),
      observation_period_end_date = as.Date("2023-12-31"),
      period_type_concept_id = 0
    )
  ),
  cdmName = "mock"
)

cdmSource(cdm)
cdmSource(cdm$person)
}
}
