% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/mvnorm.R
\name{dmvnorm_cpp}
\alias{dmvnorm_cpp}
\alias{rmvnorm_cpp}
\alias{dmvnorm}
\alias{rmvnorm}
\title{Multivariate normal distribution}
\usage{
dmvnorm_cpp(x, mean, Sigma, log = FALSE)

rmvnorm_cpp(mean, Sigma, log = FALSE)

dmvnorm(x, mean, Sigma, log = FALSE)

rmvnorm(n = 1, mean, Sigma, log = FALSE)
}
\arguments{
\item{x}{[\code{numeric()}]\cr
A quantile vector of length \code{p}.}

\item{mean}{[\code{numeric()}]\cr
The mean vector of length \code{p}.}

\item{Sigma}{[\code{matrix()}]\cr
The covariance matrix of dimension \code{p}.}

\item{log}{[\code{logical(1)}]\cr
Return the logarithm of the density value?}

\item{n}{[\code{integer(1)}]\cr
An \code{integer}, the number of samples.}
}
\value{
For \code{dmvnorm()}: The density value.

For \code{rmvnorm()}: If \code{n = 1} a \code{vector} of length \code{p}, else
a \code{matrix} of dimension \code{n} times \code{p} with samples as rows.
}
\description{
The function \code{dmvnorm()} computes the density of a multivariate normal
distribution.

The function \code{rmvnorm()} samples from a multivariate normal distribution.

The functions with suffix \verb{_cpp} perform no input checks, hence are faster.
}
\examples{
x <- c(0, 0)
mean <- c(0, 0)
Sigma <- diag(2)

# compute density
dmvnorm(x = x, mean = mean, Sigma = Sigma)
dmvnorm(x = x, mean = mean, Sigma = Sigma, log = TRUE)

# sample
rmvnorm(n = 3, mean = mean, Sigma = Sigma)
rmvnorm(mean = mean, Sigma = Sigma, log = TRUE)
}
\seealso{
Other simulation helpers: 
\code{\link{correlated_regressors}()},
\code{\link{ddirichlet_cpp}()},
\code{\link{dtnorm_cpp}()},
\code{\link{dwishart_cpp}()},
\code{\link{simulate_markov_chain}()}
}
\concept{simulation helpers}
\keyword{distribution}
