% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Driver.R
\name{dbConnect,OdbcDriver-method}
\alias{dbConnect,OdbcDriver-method}
\alias{dbConnect}
\title{Connect to a ODBC compatible database}
\usage{
\S4method{dbConnect}{OdbcDriver}(
  drv,
  dsn = NULL,
  ...,
  timezone = "UTC",
  timezone_out = "UTC",
  encoding = "",
  bigint = c("integer64", "integer", "numeric", "character"),
  timeout = 10,
  driver = NULL,
  server = NULL,
  database = NULL,
  uid = NULL,
  pwd = NULL,
  dbms.name = NULL,
  .connection_string = NULL
)
}
\arguments{
\item{drv}{an object that inherits from \linkS4class{DBIDriver},
or an existing \linkS4class{DBIConnection}
object (in order to clone an existing connection).}

\item{dsn}{The Data Source Name.}

\item{...}{Additional ODBC keywords, these will be joined with the other
arguments to form the final connection string.}

\item{timezone}{The Server time zone. Useful if the database has an internal
timezone that is \emph{not} 'UTC'. If the database is in your local timezone set
to \code{\link[=Sys.timezone]{Sys.timezone()}}. See \code{\link[=OlsonNames]{OlsonNames()}} for a complete list of available
timezones on your system.}

\item{timezone_out}{The time zone returned to R. If you want to display
datetime values in the local timezone, set to \code{Sys.timezone()}.}

\item{encoding}{The text encoding used on the Database. If the database is
not using UTF-8 you will need to set the encoding to get accurate re-encoding.
See \code{\link[=iconvlist]{iconvlist()}} for a complete list of available encodings on your system.
Note strings are always returned \code{UTF-8} encoded.}

\item{bigint}{The R type that \code{SQL_BIGINT} types should be mapped to,
default is \link[bit64:bit64-package]{bit64::integer64}, which allows the full range of 64 bit
integers.}

\item{timeout}{Time in seconds to timeout the connection attempt. Setting a
timeout of \code{Inf} indicates no timeout. (defaults to 10 seconds).}

\item{driver}{The ODBC driver name.}

\item{server}{The server hostname.}

\item{database}{The database on the server.}

\item{uid}{The user identifier.}

\item{pwd}{The password to use.}

\item{dbms.name}{The database management system name. This should normally
be queried automatically by the ODBC driver. This name is used as the class
name for the OdbcConnect object returned from \code{dbConnect()}. However if the
driver does not return a valid value it can be set manually with this
parameter. Any non-alphanumeric or space characters are converted to spaces
in the name.}

\item{.connection_string}{A complete connection string, useful if you are
copy pasting it from another source. If this argument is used any additional
arguments will be appended to this string.}
}
\description{
Connect to a ODBC compatible database
}
\details{
The connection string keywords are driver dependent. The parameters
documented here are common, but some drivers may not accept them. Please see
the specific driver documentation for allowed parameters,
\url{https://www.connectionstrings.com} is also a useful resource of example
connection strings for a variety of databases.
}
