% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ocsApiWebdavManager.R
\docType{class}
\name{ocsApiWebdavManager}
\alias{ocsApiWebdavManager}
\title{ocsApiWebdavManager}
\format{\code{\link{R6Class}} object.}
\usage{
ocsApiWebdavManager
}
\value{
Object of \code{\link{R6Class}} for modelling an ocsManager for Webdav API
}
\description{
ocsApiWebdavManager
}
\section{General Methods (inherited from 'ocsManager')}{

\describe{
 \item{\code{new(url, user, pwd, logger)}}{
   This method is used to instantiate an ocsApiWebdavManager. The user/pwd are
   mandatory in order to connect to 'ocs'. The logger can be either
   NULL, "INFO" (with minimum logs), or "DEBUG" (for complete curl 
   http calls logs)
 }
 \item{\code{connect()}}{
   A method to connect to 'ocs' and set version/capabilities
 }
 \item{\code{getVersion()}}{
   Get the 'ocs' server version
 }
 \item{\code{getCapabilities()}}{
   Get the 'ocs' server capabilities
 }
}
}

\section{WebDAV methods}{

\describe{
 \item{\code{getWebdavRoot()}}{
   Get the 'ocs' WebDAV root URL
 }
 \item{\code{listFiles(relPath)}}{
   WebDAV method to list folders/files given a relative path. The relative path is set
   to \code{"/"} by default, which corresponds to the root of the 'ocs' repository.
 }
 \item{\code{makeCollection(name, relPath)}}{
   WebDAV method to make a collection. By default \code{relPath} is set to \code{"/"} (root).
   The \code{name} is the name of the new collection to be created. The function is recursive
   in the sense that a \code{name} can be provided as relative path of a collection tree 
   (eg \code{newfolder1/newfolder2/newfolder3}), the function will create recursively as 
   many collections are handled in the name. 
 }
 \item{\code{uploadFile(filename, relPath)}}{
   WebDAV method to upload a file. By default \code{relPath} is set to \code{"/"} (root).
 }
}
}

\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{manager}
\keyword{ocs}
\keyword{webdav}
