% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_attr.R
\name{extract_attr}
\alias{extract_attr}
\title{Extract attributes}
\usage{
extract_attr(x, str_attr)
}
\arguments{
\item{x}{A list of objects with attributes or an object with an attribute}

\item{str_attr}{A non-empty character string specifying which attribute is to
be extracted}
}
\value{
Returns a list the length of x containing the specified attribute. If
the attribute does not exist, returns NULL
}
\description{
Extracts the attributes of objects nested in a list
}
\examples{
design_opt_input <- list(rules = 4, actions = 5)
design <- generate_designs(design_opt_input)
extract_attr(design, "design_conditions")

design_opt_input <- list(rules = 4, actions = 5, designs = 2)
design <- generate_designs(design_opt_input)
extract_attr(design, "design_conditions")

}
