% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plsda.R
\name{plsda}
\alias{plsda}
\title{Partial least squares discriminant analysis}
\usage{
plsda(X, Y, nc, scale, center)
}
\arguments{
\item{X}{a matrix of predictor variables.}

\item{Y}{a single vector indicate the group}

\item{nc}{the number of pls components (the one joint components + 
number of orthogonal components ).}

\item{scale}{logical indicating whether \code{X} must be scaled (suggest TRUE).}

\item{center}{logical indicating whether \code{X} must be centered (suggest TRUE).}
}
\value{
a list containing the following elements:
\itemize{
\item{\code{nc}}{ the number of components used(one joint components + 
 number of orthogonal components }
\item{\code{scores}}{ a matrix of scores corresponding to the observations 
in \code{X}, The components retrieved correspond to the ones optimized 
or specified.}
\item{\code{Xloadings}}{ a matrix of loadings corresponding to the
 explanatory variables. The components retrieved correspond to the ones
 optimized or specified.}
\item{\code{vip}}{ the VIP matrix.}
\item{\code{xvar}}{ variance explained by each single component}}
}
\description{
Perform a PLS discriminant analysis
}
\examples{
X <- matrix(rnorm(50),10,5)
Y <- rep(c(0,1),each=5)
fit <- plsda(X,Y,2)
}
\author{
Kai Guo
}
