% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{get_all_nutrient_info}
\alias{get_all_nutrient_info}
\title{get_all_nutrient_info(foodCode)}
\usage{
get_all_nutrient_info(foodCode, apiKey = NULL, lang = "en")
}
\arguments{
\item{foodCode}{The code indicating the food you want to search for.}

\item{apiKey}{Key to access the API. Can be retrieved from
\url{https://hc-sc.api.canada.ca/en/detail?api=cnf#!/Nutrient/get_nutrientamount}.
If none is provided, the system environment variables will be checked.}

\item{lang}{The language to return results in, can be either 'en' or 'fr'.}
}
\value{
A tibble containing all available nutrient information about the food code.
}
\description{
Makes queries to the Canadian Nutrient APIs to get all available nutrient information
about a particular food.
}
\examples{
\dontrun{
get_all_nutrient_info(foodCode = 45)
}
}
