% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fv_runs.R
\name{fv_runs}
\alias{fv_runs}
\title{Remove Subsequent Runs from a Vector}
\usage{
fv_runs(x, fill = "", missing = NA, ...)
}
\arguments{
\item{x}{A vector with runs.}

\item{fill}{What to fill in subsequent runs with.}

\item{missing}{What to fill in missing values with.}

\item{\ldots}{ignored.}
}
\value{
Returns a vector of strings with subsequent runs removed.
}
\description{
Remove subsequent runs from a vector.
}
\examples{
x <- c(1, 1 , 2, 3, 4, 4, 1, 1, 3, 3, NA, 5)
fv_runs(x)
fv_runs(x, fill = '-')
fv_runs(x, fill = '-', missing = 'X')

\dontrun{
library(dplyr)

set.seed(10)
data.frame(
    state = sort(sample(state.name[c(1, 5, 9, 12)], 12, TRUE)),
    val = rnorm(12)
) \%>\%
    mutate(state2 = fv_runs(state))
}
}
