% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_date.R
\name{f_date}
\alias{f_date}
\alias{ff_date}
\title{Format Dates}
\usage{
f_date(x = Sys.Date(), format = "\%B \%d, \%Y", ...)

ff_date(...)
}
\arguments{
\item{x}{A vector of coercable dates.}

\item{format}{A character string specifying the date output format.}

\item{\ldots}{Other arguments passed to \code{\link[base]{as.Date}}.}
}
\value{
Returns a string of publication ready dates.
}
\description{
Format dates to the typical '%B %d, %Y in-text format.
}
\examples{
f_date(Sys.Date())
f_date(Sys.time())
f_date(Sys.time(), '\%b-\%y')
set.seed(10)
dates <- as.Date(sample(1:10000, 12), origin = '1970-01-01')
paste(f_date(range(dates)), collapse = ' to ')
}
