% Generated by roxygen2 (4.0.2): do not edit by hand
\name{sep_dist}
\alias{sep_dist}
\title{Distance based on separation of clusters}
\usage{
sep_dist(X, PX, clustering = FALSE, nclust = 3)
}
\arguments{
\item{X}{a data.frame with two or three columns, the first two columns
providing the dataset}

\item{PX}{a data.frame with two or three columns, the first two columns
providing the dataset}

\item{clustering}{LOGICAL; if TRUE, the third column is used as the
clustering variable, by default FALSE}

\item{nclust}{the number of clusters to be obtained by hierarchial
clustering, by default nclust = 3}
}
\value{
distance between X and PX
}
\description{
The separation between clusters is defined by the minimum distances of a point in
the cluster to a point in another cluster. The number of clusters are provided.
If not, the hierarchical clustering method is used to obtain the clusters. The
separation between the clusters for dataset X is calculated. Same is done for
dataset PX. An euclidean distance is then calculated between these separation for
X and PX.
}
\examples{
if(require('fpc')) { with(mtcars, sep_dist(data.frame(wt, mpg,
as.numeric(as.factor(mtcars$cyl))), data.frame(sample(wt), mpg,
as.numeric(as.factor(mtcars$cyl))), clustering = TRUE))}
}

