% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PhenMap.R
\name{PhenMap}
\alias{PhenMap}
\title{PhenMap}
\usage{
PhenMap(s, dates, h, nGS, nCluster, outname, format, datatype, rge)
}
\arguments{
\item{s}{Raster stack with greenness (e,g. NDVI or EV) values}

\item{dates}{Vector with dates at which the greenness values were recorded}

\item{h}{Numeric. Indicates the geographic hemisphere to define the starting date of the growing season. h=1 if the vegetation is in the Northern Hemisphere (season starting at January 1st), h=2 if it is in the Southern Hemisphere (season starting at July 1st)}

\item{nGS}{Numeric. Number of greenness values within a single growing season. For example, nGS=23 for MODIS    Vegetation Index 16-days composites}

\item{nCluster}{Numeric. Number of CPU cores to be used for computational calculations}

\item{outname}{Character vector with the output path and filename with extension or only the filename and extension if work directory was set. For example outname="output_phen.tif". See \code{\link{writeRaster}}}

\item{format}{Character. Output file type. See \code{\link{writeFormats}}}

\item{datatype}{Character. Output data type. See \code{\link{dataType}}}

\item{rge}{A vector containing minimum and maximum values of the response variable used in the analysis. We suggest the use of theoretically based limits. For example in the case of MODIS NDVI or EVI, it ranges from 0 to 10,000, so rge =c(0,10000)}
}
\value{
RasterStack
}
\description{
Estimates annual Land Surface Phenology (LSP) using time series of  a vegetation greenness raster stack.
}
\details{
Derives the annual Land Surface Phenological (LSP) cycle for a standard growing season using a raster stack of satellite based greenness values such as the Normalized Difference Vegetation Index (NDVI) or Enhanced Vegetation Index (EVI). The LSP cycle is calculated for all pixels of the input raster stack in the same way as for the Phen function. The output is a multiband raster where every band is the expected greeness value at a given time step of the standard growing season. For example, for MODIS Vegetation Index 16-days composites the number of time steps of the growing season (nGS) is 23 , and therefore, the output raster will have 23 bands. A vector with dates for the greenness values is also required.
}
\examples{
\donttest{
##DEPENDING ON HARDWARE, THIS PROCESS CAN BE HIGHLY TIME CONSUMING##

## Testing North Hemisphere data. Raster data from Slovenia (EVI index), h=1 ##

# Load data
sl.path<-system.file("extdata/HN_slovenia",package="npphen")
sl_rasters<-list.files(path=sl.path, pattern=glob2rx("slovenia*.tif"), full.names=TRUE)
Slovenia_rasters<-stack(sl_rasters)
sl_dates<-read.csv(system.file("extdata/date_tables/Slovenia_dates.csv", package="npphen"))
Slovenia_dates <- as.Date(sl_dates$date, format='\%d/\%m/\%Y')

# Making the LSP raster, n bands = 23

library(snow)

# Define the number of cores to be use. In this example we use 1
nc1<-1

PhenMap(s=Slovenia_rasters,dates=Slovenia_dates,h=1,nGS=23, nCluster=nc1,
outname="phen_slov.tif", format="GTiff", datatype="FLT4S",rge=c(0,10000))
map1<-raster("phen_slov.tif")
plot(map1)

## Testing South Hemisphere data. Raster data from Chile (EVI index), h=2 ##

# Load data
ay.path<-system.file("extdata/HS_aysen",package="npphen")
ayrasters<-list.files(path=ay.path, pattern=glob2rx("aysen*.tif"), full.names=TRUE)
Aysen_rasters<-stack(ayrasters)
ay_dates<-read.csv(system.file("extdata/date_tables/Aysen_dates.csv", package="npphen"))
Aysen_dates <- as.Date(ay_dates$date, format='\%d/\%m/\%Y')

# Making the LSP raster, n bands = 23
# Define the number of cores to be use. In this example we use 1
nc1<-1

PhenMap(s= Aysen_rasters,dates=Aysen_dates,h=2,nGS=23, nCluster=nc1,
outname="phen_aysen.tif", format="GTiff", datatype="FLT4S",rge=c(0,10000))
map2<-raster("phen_aysen.tif")
plot(map2)
}
}
\seealso{
\code{\link{Phen}}
}
