% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replext_ts2.R
\name{replext_ts2_c4.2}
\alias{replext_ts2_c4.2}
\title{Replicate and Extend Type I Error Rates for ANOVA with Specific Sample Size Combinations}
\usage{
replext_ts2_c4.2(
  M1 = 5,
  S1 = 1,
  M2 = 5,
  S2 = 2,
  M3 = 5,
  S3 = 4,
  Sk1 = 0.8,
  Sk2 = 0.8,
  Sk3 = 0.8,
  n1 = c(2, 2, 2, 3, 2, 2, 3, 2, 3, 2),
  n2 = c(2, 3, 3, 4, 2, 3, 4, 2, 4, 2),
  n3 = c(3, 3, 4, 3, 6, 6, 4, 7, 5, 8),
  n_simulations = 10000,
  nboot = 1000,
  conf.level = 0.95
)
}
\arguments{
\item{M1}{Mean for the first group, default is 5.}

\item{S1}{Standard deviation for the first group, default is 1.}

\item{M2}{Mean for the second group, default is 5.}

\item{S2}{Standard deviation for the second group, default is 2.}

\item{M3}{Mean for the third group, default is 5.}

\item{S3}{Standard deviation for the third group, default is 4.}

\item{Sk1}{Skewness parameter for the first group, default is 0.8.}

\item{Sk2}{Skewness parameter for the second group, default is 0.8.}

\item{Sk3}{Skewness parameter for the third group, default is 0.8.}

\item{n1}{Vector of sample sizes for the first group, with specific combinations.}

\item{n2}{Vector of sample sizes for the second group, with specific combinations.}

\item{n3}{Vector of sample sizes for the third group, with specific combinations.}

\item{n_simulations}{Number of simulations to run, default is 10,000.}

\item{nboot}{Number of bootstrap samples for the nonparametric bootstrap test, default is 1000.}

\item{conf.level}{Confidence level for calculating p-value thresholds, default is 0.95.}
}
\value{
A data frame with results extending those from \code{replext_ts2_c1.1}. This data frame
provides insights into the Type I error rates for each test (ANOVA, Kruskal-Wallis,
Nonparametric Bootstrap F-test, Permutation F-test) under the conditions of skewness,
varying sample sizes, and varying standrd deviations.
}
\description{
\code{replext_ts2_c4.2} is designed to explore the impact of specific combinations of sample sizes
on the Type I error rates in ANOVA (Analysis of Variance) under conditions of skewness and
varying standard deviations. This function extends \code{replext_ts2_c1.1} by utilizing unique sample
size combinations along with altered default standard deviations and skewness parameters. It is
part of a broader analysis aimed at understanding statistical behavior in skewed and heteroscedastic
scenarios, aligning with the research context provided by Dwivedi et al. (2017).
}
\examples{
replext_ts2_c4.2(n1 = c(10), n2 = c(10), n3 = c(10), n_simulations = 1)

}
\references{
Dwivedi AK, Mallawaarachchi I, Alvarado LA. Analysis of small sample size
studies using nonparametric bootstrap test with pooled resampling method.
Stat Med. 2017 Jun 30;36(14):2187-2205. doi: 10.1002/sim.7263. Epub 2017 Mar 9. PMID: 28276584.
}
\seealso{
\code{\link{replext_ts2_c1.1}}
}
