% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concordance.test.R
\docType{methods}
\name{concordance.test}
\alias{concordance.test}
\alias{nopaco}
\title{Perform a nonparametric concordance test.}
\usage{
concordance.test(x, y = NULL, alternative = NULL, alpha = 0.05, ...)
}
\arguments{
\item{x}{a numeric matrix, subjects in the rows, repeated measurements in the columns}

\item{y}{(optional) a numeric matrix of equal size as argument \code{x}}

\item{alternative}{"less", "greater" or "two.sided". Only used when \code{y} is given.}

\item{alpha}{significance level (default = 0.05)}

\item{...}{see details}
}
\value{
An object of \code{\link{ConcordanceTest-class}}
}
\description{
\code{concordance.test} performs a test for a random concordance (if a single matrix is given) or tests for equal concordance between two matrices.
}
\details{
\itemize{
\item Testing the deviation from random concordance: if only one matrix is given (i.e. argument \code{x}), its concordance will be tested for a deviation from a random concordance. The default alternative hypothesis is 'greater', thus higher concordance than would have been observed by chance. For small matrices (depending on number of replicate measurements) an exact method will be used to determine to p-value. In case of larger matrices either, the alternative beta approach (default), a beta approximation or a normal approximation is used. To enforce the use of either one method, the \code{method} argument can be used with value "exact","alt.beta","beta" or "normal".
\item Testing for a difference between concordances: if both arguments \code{x} and \code{y} have been given, the equality of concordances of both matrices is tested. The default alternative hypothesis is 'two.sided'. Both matrices must be of equal size and have corresponding missing entries. Eventual missing data in one matrix will also be set missing in the other.
}
Unbalanced data due to randomly missing data or an unequal number of repeated measurements per subject is allowed. In that case, missing or unknown values must be set to \code{NA}.
}
\examples{
require(MASS) ##to use mvrnorm function

#Generate a matrix without concordance
matRandom <- matrix(rnorm(3*20),20,3)
concordance.test(matRandom) 

#Generate a matrix with strong concordance
sigma<-matrix(0.8,3,3)
diag(sigma)<-1
matConcordant <- mvrnorm(20,mu=rep(0,3),Sigma=sigma)
concordance.test(matConcordant)

#Test concordances between matrices
aTest <- concordance.test(matConcordant, matRandom)

getPsi(aTest)
coef(aTest)

}
\references{
P.Rothery (1979) Biometrika 66(3):629-639
}
\seealso{
Other concordance functions: \code{\link{coef}},
  \code{\link{getPsi}}, \code{\link{rfromPsi}}
}
