% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula_lp.R
\name{formula_lp}
\alias{formula_lp}
\title{Explore the Formula of Total Points and Linear Predictors}
\usage{
formula_lp(nomogram, power, digits = 6)
}
\arguments{
\item{nomogram}{results of nomogram() function in 'rms' package}

\item{power}{power can be automatically selected based on all R2 equal 1}

\item{digits}{default is 6}
}
\value{
formula is the formula of total points and linear predictors. test is the R2 and RMSE which are used to test the fitted points. diff is difference between nomogram points and fitted points
}
\description{
Explore the formula of total points and linear predictors by the best power.
}
\examples{
library(rms)  # needed for nomogram
set.seed(2018)
n <-2019
age <- rnorm(n,60,20)
sex <- factor(sample(c('female','male'),n,TRUE))
sex <- as.numeric(sex)
weight <- sample(50:100,n,replace = TRUE)
time <- sample(50:800,n,replace = TRUE)
units(time)="day"
death <- sample(c(1,0,0),n,replace = TRUE)
df <- data.frame(time,death,age,sex,weight)
ddist <- datadist(df)
oldoption <- options(datadist='ddist')
f <- cph(formula(Surv(time,death)~sex+age+weight),data=df,
         x=TRUE,y=TRUE,surv=TRUE,time.inc=3)
surv <- Survival(f)
nomo <- nomogram(f,
                 lp=TRUE,
                 fun=list(function(x) surv(365,x),
                          function(x) surv(365*2,x)),
                 funlabel=c("1-Year Survival Prob",
                            "2-Year Survival Prob"))
options(oldoption)
formula_lp(nomogram = nomo)
formula_lp(nomogram = nomo,power = 1)
formula_lp(nomogram = nomo,power = 3,digits=6)
}
