% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prob_cal.R
\name{prob_cal}
\alias{prob_cal}
\title{calculate Probabilities}
\usage{
prob_cal(formula, totalpoints, digits = 6)
}
\arguments{
\item{formula}{the formula of probabilities and total points}

\item{totalpoints}{totalpoints after function points_cal}

\item{digits}{default is 6}
}
\value{
probabilities as a dataframe
}
\description{
Calculate probabilities.
}
\examples{
library(rms)  # needed for nomogram
set.seed(2018)
n <-2019
age <- rnorm(n,60,20)
sex <- factor(sample(c('female','male'),n,TRUE))
sex <- as.numeric(sex)
weight <- sample(50:100,n,replace = TRUE)
time <- sample(50:800,n,replace = TRUE)
units(time)="day"
death <- sample(c(1,0,0),n,replace = TRUE)
df <- data.frame(time,death,age,sex,weight)
ddist <- datadist(df)
oldoption <- options(datadist='ddist')
f <- cph(formula(Surv(time,death)~sex+age+weight),data=df,
         linear.predictors=TRUE,
         x=TRUE,y=TRUE,surv=TRUE,time.inc=3)
surv <- Survival(f)
nomo <- nomogram(f,
                 lp=TRUE,
                 fun=list(function(x) surv(365,x),
                          function(x) surv(365*2,x)),
                 funlabel=c("1-Year Survival Prob",
                            "2-Year Survival Prob"))
options(oldoption)
results <- formula_lp(nomo)
totalpoints <- points_cal(formula = results$formula,lp=f$linear.predictors)
results_2 <- formula_prob(nomo) 
prob_cal(formula = results_2$formula,totalpoints =totalpoints)
}
