% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/content_type.R
\name{nomis_content_type}
\alias{nomis_content_type}
\title{Nomis dataset content types}
\usage{
nomis_content_type(content_type, id = NULL)
}
\arguments{
\item{content_type}{A string with the content type to return metadata on.}

\item{id}{A string with an optional \code{content_type} id.}
}
\value{
A tibble with metadata on a given content type.
}
\description{
Nomis content type metadata is included in annotation tags, in the form of
\verb{contenttype/<contenttype>} in the \code{annotationtitle} column in
the \code{annotations.annotation} list-column returned from
\code{\link[=nomis_data_info]{nomis_data_info()}}. For example, the content types returned from
dataset "NM_1658_1", using \code{nomis_data_info("NM_1658_1")}, are
"geoglevel", "2001census" and "sources".
}
\examples{
\donttest{
a <- nomis_content_type("sources")

tibble::glimpse(a)

b <- nomis_content_type("sources", id = "census")

tibble::glimpse(b)
}

}
\seealso{
\code{\link[=nomis_search]{nomis_search()}}

\code{\link[=nomis_data_info]{nomis_data_info()}}
}
