% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/greensIndex.R
\name{print.greensIndex}
\alias{print.greensIndex}
\title{\code{\link[=print]{print()}} helper function for \code{print.greensIndex()} function}
\usage{
\method{print}{greensIndex}(x, ...)
}
\arguments{
\item{x}{Object resulting from applying the \code{\link[=greensIndex]{greensIndex()}} function}

\item{...}{Additional \code{\link[=print]{print()}} parameters}
}
\value{
Printed output of \code{\link[=greensIndex]{greensIndex()}} function
}
\description{
\code{\link[=print]{print()}} helper function for \code{print.greensIndex()} function
}
\examples{
# Apply Green's Index using anthropometric data from a SMART survey in Sudan
# (flag.ex01)
svy <- flag.ex01
svy$flag <- 0
svy$flag <- ifelse(!is.na(svy$haz) & (svy$haz < -6 | svy$haz > 6), svy$flag + 1, svy$flag)
svy$flag <- ifelse(!is.na(svy$whz) & (svy$whz < -5 | svy$whz > 5), svy$flag + 2, svy$flag)
svy$flag <- ifelse(!is.na(svy$waz) & (svy$waz < -6 | svy$waz > 5), svy$flag + 4, svy$flag)
svy <- svy[svy$flag == 0, ]
svy$stunted <- ifelse(svy$haz < -2, 1, 2)
gi <- greensIndex(data = svy, psu = "psu", case = "stunted")
print(gi)

}
