% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HMC_configuration.R
\name{addHMC}
\alias{addHMC}
\title{Add HMC sampler}
\usage{
addHMC(
  conf,
  target = character(),
  type = "NUTS",
  control = list(),
  replace = FALSE,
  print = TRUE,
  ...
)
}
\arguments{
\item{conf}{A nimble MCMC configuration object, as returned by `configureMCMC`.}

\item{target}{A character vector of continuous-valued stochastic node names to sample.  If this argument contains any discrete-valued nodes, an error is produced and no sampler is added.}

\item{type}{A character string specifying the type of HMC sampler to add, either "NUTS" or "NUTS_classic".  See `help(NUTS)` or `help(NUTS_classic)` for details of each sampler.  The default sampler type is "NUTS".}

\item{control}{Optional named list of control parameters to be passed as the `control` argument to the HMC sampler.  See `help(NUTS)` or `help(NUTS_classic)` for details of the control list elements accepted by each sampler.}

\item{replace}{Logical argument.  If `TRUE`, any existing samplers operating on the specified nodes will be removed, prior to adding the HMC sampler.  Default value is `FALSE`.}

\item{print}{Logical argument whether to print the newly added HMC sampler.  Default value is `TRUE`.}

\item{...}{Additional named arguments passed through ... will be used as additional control list elements.}
}
\value{
Invisibly returns an object of class `MCMCconf`, but this function is primary called for its side effect.
}
\description{
Add a No-U-Turn (NUTS) Hamiltonian Monte Carlo (HMC) sampler to an existing nimble MCMC configuration object
}
\details{
This function adds an HMC sampler to an MCMC configuration object.  Use this function if you have already created an MCMC configuration and want to add an HMC sampler.  Optionally, using `replace = TRUE`, this function will also remove any existing samplers operating on the target node(s).

Either the `NUTS_classic` or the `NUTS` sampler can be added.  Both implement variants of No-U-Turn HMC sampling, however the `NUTS` sampler uses more modern adapatation techniques.  See `help(NUTS)` or `help(NUTS_classic)` for details.

Use `conf$addSampler` instead if you need more fine-grained control.  See `help(configureMCMC)` in nimble.
}
\examples{
code <- nimbleCode({
    b0 ~ dnorm(0, 0.001)
    b1 ~ dnorm(0, 0.001)
    sigma ~ dunif(0, 10000)
    for(i in 1:N) {
        mu[i] <- b0 + b1 * x[i]
        y[i] ~ dnorm(mu[i], sd = sigma)
    }
})

N <- 10
constants <- list(N = N, x = 1:N)
data <- list(y = 1:N)
inits <- list(b0 = 1, b1 = 0.1, sigma = 1)

Rmodel <- nimbleModel(code, constants, data, inits, buildDerivs = TRUE)

## create MCMC configuration object
conf <- configureMCMC(Rmodel, nodes = NULL)

## add HMC sampler operating on all stochastic model nodes
addHMC(conf)

Rmcmc <- buildMCMC(conf)

# Cmodel <- compileNimble(Rmodel)
# Cmcmc <- compileNimble(Rmcmc, project = Rmodel)
# samples <- runMCMC(Cmcmc)
}
\seealso{
\code{\link{configureHMC}} \code{\link{buildHMC}} \code{\link{configureMCMC}} \code{\link{addSampler}} \code{\link{sampler_NUTS}} \code{\link{sampler_NUTS_classic}}
}
\author{
Daniel Turek
}
