% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMC_utils.R
\name{decideAndJump}
\alias{decideAndJump}
\title{Creates a nimbleFunction for executing the Metropolis-Hastings jumping decision,
and updating values in the model, or in a carbon copy modelValues object, accordingly.}
\usage{
decideAndJump(model, mvSaved, target, calcNodes)
}
\arguments{
\item{model}{An uncompiled or compiled NIMBLE model object.}

\item{mvSaved}{A modelValues object containing identical variables and logProb variables as the model. Can be created by \code{modelValues(model)}.}

\item{target}{A character vector providing the target node.}

\item{calcNodes}{A character vector representing a set of nodes in the model (and hence also the modelValues) object.}
}
\description{
This nimbleFunction generator must be specialized to three required arguments: a model, a modelValues, and a character vector of node names.
}
\details{
Calling decideAndJump(model, mvSaved, calcNodes) will generate a specialized nimbleFunction with four required numeric arguments:

modelLP1: The model log-probability associated with the newly proposed value(s)

modelLP0: The model log-probability associated with the original value(s)

propLP1: The log-probability associated with the proposal forward-transition

propLP0: The log-probability associated with the proposal reverse-tranisiton

Executing this function has the following effects:
-- Calculate the (log) Metropolis-Hastings ratio, as logMHR = modelLP1 - modelLP0 - propLP1 + propLP0
-- Make the proposal acceptance decision based upon the (log) Metropolis-Hastings ratio
-- If the proposal is accepted, the values and associated logProbs of all calcNodes are copied from the model object into the mvSaved object
-- If the proposal is rejected, the values and associated logProbs of all calcNodes are copied from the mvSaved object into the model object
-- Return a logical value, indicating whether the proposal was accepted
}
\author{
Daniel Turek
}

