% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-invert_bijection.R
\name{inverse_with_uniroot_sorted}
\alias{inverse_with_uniroot_sorted}
\title{Numerically evaluate the inverse of a monotonically increasing continuous
function from R to R at specific points.}
\usage{
inverse_with_uniroot_sorted(
  f,
  y,
  range_x = c(0, 10),
  range_y = c(f(range_x[1]), f(range_x[2]))
)
}
\arguments{
\item{f}{(function) the function to be inverted; must be continuous
and increasing}

\item{y}{(vector, double) the f(x)=y values in which to evaluate the inverse;
must be in ascending order}

\item{range_x}{(vector, double) the min and max of the domain of f()}

\item{range_y}{(vector, double) the min and max in the range of f()}
}
\value{
(vector, double) vector of x=f^(-1)(y): the inverted values
}
\description{
Numerically evaluate the inverse of a monotonically increasing continuous
function from R to R at specific points.
}
\examples{
inverse_with_uniroot_sorted(f = function(x) {
  2 * x
}, y = c(0, 0.5))
}
