% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloading_tools.R
\name{download_wbd}
\alias{download_wbd}
\title{Download the seamless Watershed Boundary Dataset (WBD)}
\usage{
download_wbd(
  outdir,
  url = paste0("https://prd-tnm.s3.amazonaws.com/StagedProducts/",
    "Hydrography/WBD/National/GDB/WBD_National_GDB.zip")
)
}
\arguments{
\item{outdir}{The folder path where data should be downloaded and extracted}

\item{url}{the location of the online resource}
}
\value{
the path to the local geodatabase
}
\description{
This function downloads and decompresses staged seamless WBD data.
Please see:
https://prd-tnm.s3.amazonaws.com/StagedProducts/Hydrography/WBD/National/GDB/WBD_National_GDB.xml
for metadata.
}
\examples{
\dontrun{
  download_wbd("./data/wbd/")
}
}
