% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_paths.R
\name{get_levelpaths}
\alias{get_levelpaths}
\title{Get Level Paths}
\usage{
get_levelpaths(x, status = FALSE)
}
\arguments{
\item{x}{data.frame with ID, toID, nameID, and weight columns.}

\item{status}{boolean if status updates should be printed.}
}
\value{
data.frame with ID, outletID, topo_sort, and levelpath columns.
See details for more info.
}
\description{
Calculates level paths using the stream-leveling approach of
NHD and NHDPlus. In addition to a levelpath identifier, a topological sort and
levelpath outlet identifier is provided in output. If arbolate sum is provided in
the weight column, this will match the behavior of NHDPlus. Any numeric value can be
included in this column and the largest value will be followed when no nameID is available.
}
\details{
\enumerate{
  \item levelpath provides an identifier for the collection of flowlines
  that make up the single mainstem flowpath of a total upstream aggregate catchment.
  \item outletID is the catchment ID (COMID in the case of NHDPlus) for the catchment
  at the outlet of the levelpath the catchment is part of.
  \item topo_sort is similar to Hydroseq in NHDPlus in that large topo_sort values
  are upstream of small topo_sort values. Note that there are many valid topological
  sort orders of a directed graph. The sort order output by this function is generated
  using `igraph::topo_sort`.
}
}
\examples{
source(system.file("extdata", "walker_data.R", package = "nhdplusTools"))

test_flowline <- prepare_nhdplus(walker_flowline, 0, 0, FALSE)

test_flowline <- data.frame(
  ID = test_flowline$COMID,
  toID = test_flowline$toCOMID,
  nameID = walker_flowline$GNIS_ID,
  weight = walker_flowline$ArbolateSu,
  stringsAsFactors = FALSE)

get_levelpaths(test_flowline)


}
