% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{nhd_plus_query}
\alias{nhd_plus_query}
\title{Select NHDplus features via polygon or circular buffer of coordinate pair}
\usage{
nhd_plus_query(
  lon = NA,
  lat = NA,
  poly = NA,
  dsn,
  buffer_dist = units::as_units(4.75, "km"),
  approve_all_dl = FALSE,
  temporary = TRUE,
  ...
)
}
\arguments{
\item{lon}{numeric longitude. optional}

\item{lat}{numeric latitude. optional}

\item{poly}{sfc polygon. optional}

\item{dsn}{character data source}

\item{buffer_dist}{numeric buffer in units of coordinate degrees}

\item{approve_all_dl}{logical blanket approval to download all missing data.
Defaults to TRUE if session is non-interactive.}

\item{temporary}{logical set FALSE to save data to a persistent
rappdirs location}

\item{...}{parameters passed on to sf::st_read}
}
\value{
A list of sf spatial objects
}
\description{
Select NHDplus features via polygon or circular buffer of coordinate pair
}
\examples{
\dontrun{
library(sf)
wk <- wikilake::lake_wiki("Gull Lake (Michigan)")

pnt <- st_as_sf(wk, coords = c("Lon", "Lat"), crs = 4326)
pnt <- st_transform(pnt, st_crs(vpu_shp))
# nhd_plus_list(nhdR::find_vpu(pnt))

qry <- nhd_plus_query(wk$Lon, wk$Lat,
  dsn = c("NHDWaterbody", "NHDFlowLine"), buffer_dist = units::as_units(4.75, "km"))

plot(qry$sp$NHDWaterbody$geometry, col = "blue")
plot(qry$sp$NHDFlowLine$geometry, col = "cyan", add = TRUE)
plot(qry$pnt, col = "red", pch = 19, add = TRUE)
axis(1)
axis(2)

library(ggplot2)
ggplot(qry$sp$NHDWaterbody) + geom_sf()

# query with a polygon
wbd <- qry$sp$NHDWaterbody[which.max(st_area(qry$sp$NHDWaterbody)), ]
qry_lines <- nhd_plus_query(poly = st_as_sfc(st_bbox(wbd)),
  dsn = "NHDFlowLine")
ggplot() +
  geom_sf(data = qry$sp$NHDWaterbody) +
  geom_sf(data = qry_lines$sp$NHDFlowLine, color = "red")
}
}
