% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proteinpaint_utils.R
\name{format_pp_meta_fusions}
\alias{format_pp_meta_fusions}
\title{To format ProteinPaint input meta data of gender}
\usage{
format_pp_meta_fusions(raw_meta, outfn = NULL, fusions_color = NULL, ...)
}
\arguments{
\item{raw_meta}{A data.frame contain cols of 'sample', 
'term', 'group', 'value', 'color' and 'legendorder'}

\item{outfn}{Output file, default is NULL and not output to file}

\item{fusions_color}{In one group, different fusions show different colors, 
default is NULL and use the setted theme color}

\item{...}{Parameters pass to \code{\link{set_colors}}}
}
\value{
A data frame
}
\description{
To format ProteinPaint input meta data of gender
}
\examples{

meta_template <- system.file('extdata', 
'demo/proteinpaint/heatmap_meta_template.txt', package = 'ngstk')
raw_meta <- read.table(meta_template, sep = '\\t', header = TRUE)
meta_test_1 <- raw_meta
term <- group <- 'Fusions'
meta_test_1$term <- term
meta_test_1$group <- group
meta_test_1$value <- c(rep(c('ZNF384-Fusions', 'MEF2D-Fusions'), 
3), 'TCF3-PBX1')
meta_fusions <- format_pp_meta_fusions(meta_test_1)
meta_test_2 <- raw_meta
term <- group <- c(rep(c('MEF2D-Fusions', 'ZNF384-Fusions'), 
3), 'DUX4-Fusions')
meta_test_2$term <- term
meta_test_2$group <- group
meta_test_2$value <- c('MEF2D-PA', 'EP300-ZNF384', 
'MEF2D-PB', 'ABC-ZNF384', 'MEF2D-PB', 'ABD-ZNF384', 
                       'DUX4-IGH')
meta_fusions <- format_pp_meta_fusions(meta_test_2)
}
