test_that("get_files_mtime", {
  file_a <- tempfile()
  file_b <- tempfile()
  file.create(c(file_a, file_b))
  x <- get_files_mtime(input_files = c(file_a, file_b))
  expect_that(names(x)[1], equals('files_mtime'))
  expect_that(names(x)[2], equals('status'))
  x <- get_files_mtime(input_files = c(file_a, file_b), return_check = FALSE)
  expect_that(names(x)[1], equals(NULL))
  expect_that(x[1], equals(file.info(file_a)$mtime))
  expect_that(x[2], equals(file.info(file_b)$mtime))
  x <- get_files_mtime(input_files = c(file_a, file_b), return_mtime = FALSE)
  expect_that(x, equals(TRUE))
})
test_that("get_files_ctime", {
  file_a <- tempfile()
  file_b <- tempfile()
  file.create(c(file_a, file_b))
  x <- get_files_ctime(input_files = c(file_a, file_b))
  expect_that(names(x)[1], equals('files_ctime'))
  expect_that(names(x)[2], equals('status'))
  x <- get_files_ctime(input_files = c(file_a, file_b), return_check = FALSE)
  expect_that(names(x)[1], equals(NULL))
  expect_that(x[1], equals(file.info(file_a)$ctime))
  expect_that(x[2], equals(file.info(file_b)$ctime))
})
