% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/BrainSpace.R, R/BrainVolume.R
\docType{methods}
\name{indexToCoord}
\alias{indexToCoord}
\alias{indexToCoord,BrainSpace,index-method}
\alias{indexToCoord,BrainVolume,index-method}
\title{Generic function to convert 1D indices to N-dimensional real world coordinates}
\usage{
indexToCoord(x, idx)

\S4method{indexToCoord}{BrainSpace,index}(x, idx)

\S4method{indexToCoord}{BrainVolume,index}(x, idx)
}
\arguments{
\item{x}{the object}

\item{idx}{the 1D indices}
}
\value{
a matrix of real coordinates
}
\description{
Generic function to convert 1D indices to N-dimensional real world coordinates
}
\examples{
bvol <- BrainVolume(array(0, c(10,10,10)), BrainSpace(c(10,10,10), c(1,1,1)))
idx <- 1:10
g <- indexToCoord(bvol, idx)
idx2 <- coordToIndex(bvol, g)
all.equal(idx, idx2)
}

