% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AllClass.R, R/BrainVector.R
\docType{class}
\name{BrainBucket-class}
\alias{BrainBucket}
\alias{BrainBucket-class}
\title{BrainBucket}
\usage{
BrainBucket(volumeList)
}
\arguments{
\item{volumeList}{a named list of \code{\linkS4class{BrainVolume}} instances}
}
\value{
an instance of class \code{\linkS4class{BrainBucket}}
}
\description{
a four-dimensional image that conists of a sequence of labeled image volumes backed by a list

Constructor function for \code{\linkS4class{BrainBucket}} class
}
\section{Slots}{

\describe{
\item{\code{source}}{the data source for the bucket volumes}

\item{\code{labels}}{the names of the sub-volumes contained in the bucket}

\item{\code{data}}{a list of \code{\linkS4class{BrainVolume}} instances with names corresponding to volume labels}
}}
\examples{
vol1 <- BrainVolume(rnorm(24*24*24), BrainSpace(c(24,24,24), c(1,1,1)))
vol2 <- BrainVolume(rnorm(24*24*24), BrainSpace(c(24,24,24), c(1,1,1)))
vol3 <- BrainVolume(rnorm(24*24*24), BrainSpace(c(24,24,24), c(1,1,1)))
vlist <- list(vol1,vol2,vol3)
names(vlist) <- paste0("V", 1:3)
bucket <- BrainBucket(vlist)
all.equal(dim(bucket[[1]]), dim(vol1))
}

