% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/img_color_df.R
\name{img_colour_df}
\alias{img_colour_df}
\alias{img_color_df}
\title{Convert Image to Data.frame with Colors}
\usage{
img_colour_df(img, zlim = NULL, breaks = NULL, col = gray(0:64/64))

img_color_df(...)
}
\arguments{
\item{img}{an object to be coerced to \code{nifti} using 
\code{\link{check_nifti}}}

\item{zlim}{Limits for the domain of the intensities}

\item{breaks}{Breaks for the intensities to map to colors}

\item{col}{Colors to map intensities}

\item{...}{not used}
}
\value{
A \code{data.frame} with the first columns being the x,y,z (maybe t)
coordinates (named \code{dim} and the dimension number), a \code{value} 
column that contains the intensity information, and a \code{colour} column
representing the color that voxel maps to
}
\description{
Takes in an image and a color scheme, converts that image
into a \code{data.frame} with the data and a color mapping.
}
\note{
\code{img_color_df} is a duplicate of \code{img_colour_df}
}
\examples{
img = nifti(array(rnorm(10^3), dim = rep(10, 3)))
df = img_colour_df(img)
}
