% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.R
\docType{data}
\name{social}
\alias{social}
\title{Simulated Social Engagement Data}
\format{a dataframe. Columns represent individuals (nodes) and rows represent engagement in social media group conversations}
\usage{
social
}
\description{
This simulated dataset contains binary social engagement scores for 16 individuals. For 400 social media posts
on a group forum, individuals were given a score of 1 if they engaged in group conversation regarding the post,
and a score of 0 if they did not engage with the post.
}
\examples{
head(social)
\donttest{
out1 <- impact(social, binary.data=TRUE)
summary(out1)
plot(out1)

out2 <- edge.impact(social, binary.data=TRUE, gamma=0.2, nodes=c("Kim", "Bob", "Dan"))
summary(out2)
plot(out2)

# Visualize the difference in the social networks depending
# on whether or not Joe participated (large global strength impact)
par(mfrow=c(1,2))
qgraph::qgraph(out1$Edge$lo$Joe, title="Joe Absent")
qgraph::qgraph(out1$Edge$hi$Joe, title="Joe Present")

# Visualize the difference in the social networks depending
# on whether or not Don participated (large network structure impact)
par(mfrow=c(1,2))
qgraph::qgraph(out1$Edge$lo$Don, title="Don Absent")
qgraph::qgraph(out1$Edge$hi$Don, title="Don Present")

}
}
\keyword{datasets}
