% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamix.R
\name{gamix}
\alias{gamix}
\alias{gamix.table}
\alias{gamix.igraph}
\alias{gamix.default}
\title{Gupta-Anderson-May measure of within-group mixing}
\usage{
gamix(object, ...)

\method{gamix}{table}(object, ...)

\method{gamix}{igraph}(object, vattr, ...)

\method{gamix}{default}(object, ...)
}
\arguments{
\item{object}{R object, see Details for available methods}

\item{...}{other objects passed to/from other methods}

\item{vattr}{character, name of vertex attribute}
}
\value{
Numerical value of the measure.
}
\description{
Measure of within-group mixing in networks proposed in Gupta, Anderson and
May (1989).
}
\details{
The measure varies between \code{-1/vcount(g)} for dissassortative mixing
and 1 for perfect within-group mixing. It takes a value of 0 for
proportionate mixing.

If \code{object} is a table it is interpreted as a mixing matrix.
Two-dimensional table is interpreted as a contact layer. Three-dimensional
table is interpreted as a full mixing matrix \eqn{m_{ghy}}{m[ghy]}
cross-classyfying all dyads, in which \eqn{g} and \eqn{h} correspond to
group membership of ego and alter respectively. Layers \eqn{y=1} and
\eqn{y=2} are assumed to be non-contact and contact layers respectively.

If \code{object} is of class "igraph" it is required to supply \code{vattr}
with the name of the vertex attribute to calculate intermediate mixing
matrix.
}
\examples{
gamix(WhiteKinship, "gender")
gamix(EF3, "race")
}
\references{
Gupta, S., Anderson, R., May, R. (1989) "Networks of sexual contacts:
implications for the pattern of spread of HIV", AIDS 3:807--817
}
\seealso{
Other segregation measures: 
\code{\link{assort}()},
\code{\link{coleman}()},
\code{\link{ei}()},
\code{\link{freeman}()},
\code{\link{orwg}()},
\code{\link{smi}()},
\code{\link{ssi}()}
}
\concept{segregation measures}
