% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coleman.R
\name{coleman}
\alias{coleman}
\alias{coleman.table}
\alias{coleman.igraph}
\alias{coleman.default}
\title{Coleman's homophily index}
\usage{
coleman(object, ...)

\method{coleman}{table}(object, gsizes = NULL, loops = FALSE, ...)

\method{coleman}{igraph}(object, vattr, ...)

\method{coleman}{default}(object, ...)
}
\arguments{
\item{object}{R object, see Details for available methods}

\item{...}{other arguments passed to/from methods}

\item{gsizes}{numeric vector of group sizes}

\item{loops}{logical, whether loops are allowed}

\item{vattr}{character, vertex attribute}
}
\value{
Vector of numeric values of the index for each group
}
\description{
Colemans's homphily index for directed networks.
}
\details{
Coleman's homophily index computes homophily scores for each group
defined by a vertex attribute.

If \code{object} is a table it is interpreted as a mixing matrix.
Two-dimensional table is interpreted as a contact layer. Three-dimensional
table is interpreted as a full mixing matrix \eqn{m_{ghy}}{m[ghy]}
cross-classyfying all dyads, in which \eqn{g} and \eqn{h} correspond to
group membership of ego and alter respectively. Layers \eqn{y=1} and
\eqn{y=2} are assumed to be non-contact and contact layers respectively.

If \code{object} is of class "igraph" it is required to supply \code{vattr}
with the name of the vertex attribute to calculate intermediate mixing
matrix.
}
\examples{
if(requireNamespace("igraph", quietly = TRUE)) {
  # Converting networks to directed
  coleman(igraph::as.directed(WhiteKinship, "mutual"), "gender")
  coleman(igraph::as.directed(EF3, "mutual"), "race")
}
}
\references{
Coleman, J. (1958) "Relational analysis: The study of social organizations
with survey methods", \emph{Human Organization} 17:28--36.
}
\seealso{
Other segregation measures: 
\code{\link{assort}()},
\code{\link{ei}()},
\code{\link{freeman}()},
\code{\link{gamix}()},
\code{\link{orwg}()},
\code{\link{smi}()},
\code{\link{ssi}()}
}
\concept{segregation measures}
