% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vnet.R
\name{vnet}
\alias{vnet}
\alias{vhat_exch}
\title{Variance computation for linear regression of network response}
\usage{
vnet(e = NULL, X = NULL, directed = TRUE, nodes = NULL,
  type = "exchangeable", fit = NULL)
}
\arguments{
\item{e}{Optional vector of residuals, of length \eqn{d}. Column-wise unfolding of adjacency matrix without diagonal entries (self-loops).}

\item{X}{Optional matrix of covariates from regression, must have \eqn{d} rows.}

\item{directed}{Optional logical indicator of whether input data is for a directed network, default is \code{TRUE}. Undirected data format is lower triangle of adjacencey matrix.}

\item{nodes}{Optional \eqn{d \times 2} matrix indicating the (directed) relation pairs to which each entry in \eqn{e} and each row in \eqn{X} corresponds. If not input, complete network observation is assumed and the size \eqn{d} and \code{directed} must correspond to an appropriate network of size \eqn{n}.}

\item{type}{Optional string indicating whether the `meat' in the sandwich variance estimator is estimated using exchangeable theory (see Marrs et. al. (2017)) or using dyadic clustering (Fafchamps and Gubert (2007)).}

\item{fit}{Optional fitted model object. One of either \code{fit} or the pair \code{(e, X)} must be specified. Defaults to \code{fit} if both entered. Designed around `lmnet' class but may work for others, such as `lm'}
}
\value{
A an object of class \code{vhat} containing summary information:
\item{vhat}{Estimated variance-covariance matrix of cofficient estimates \eqn{\hat{\beta}}.}
\item{phi}{Vector of variance-covariance parameter estimates.}
\item{corrected}{Logical of whether variance-covariance matrix was corrected from negative definite to positive semi-definite.}
\item{type}{See inputs}
}
\description{
Stand-alone estimation of exchangeable variance matrix based on residuals and design matrix.
}
\details{
This function takes \eqn{X} and \eqn{e} values computes the variance-covariance matrix of \eqn{\hat{\beta}} that resulted in the residuals \eqn{e = Y - X \hat{\beta}} assuming that the errors are exchangeable, as based on Marrs et. al. (2017) when \code{type = "exchangeable"}. When \code{type = "dyadic clustering"}, the theory from Fafchamps and Gubert (2007) is implemented.
}
\examples{
set.seed(1)
n <- 10
d <- n*(n-1)
X <- cbind(1, rnorm(d), sample(c(0,1), d, replace=TRUE))
e <- rnorm(d)
vnet(e=e,X=X)

}
\references{
Marrs, F. W., McCormick, T. H., & Fosdick, B. K. (2017). Standard errors for regression on relational data with exchangeable errors. arXiv preprint arXiv:1701.05530.

Fafchamps, M., & Gubert, F. (2007). Risk sharing and network formation. American Economic Review, 97(2), 75-79.
}
\seealso{
\code{\link{lmnet}}, \code{\link{inputs_lmnet}}
}
\keyword{external}
