% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subgroup.netmeta.R
\name{subgroup.netmeta}
\alias{subgroup.netmeta}
\alias{subgroup}
\alias{print.subgroup.netmeta}
\title{Subgroup analysis for network meta-analysis}
\usage{
\method{subgroup}{netmeta}(
  x,
  subgroup,
  only.connected = FALSE,
  common = x$common,
  random = x$random,
  method.tau = x$method.tau,
  level.ma = x$level.ma,
  backtransf = x$backtransf,
  nchar.trts = x$nchar.trts,
  ...
)

subgroup(x, ...)

\method{print}{subgroup.netmeta}(
  x,
  common = x$x$common,
  random = x$x$random,
  backtransf = x$x$backtransf,
  nchar.trts = x$x$nchar.trts,
  digits = gs("digits"),
  digits.se = gs("digits.se"),
  digits.Q = gs("digits.Q"),
  digits.pval.Q = gs("digits.pval.Q"),
  digits.tau2 = gs("digits.tau2"),
  digits.tau = gs("digits.tau"),
  big.mark = gs("big.mark"),
  scientific.pval = gs("scientific.pval"),
  zero.pval = gs("zero.pval"),
  JAMA.pval = gs("JAMA.pval"),
  print.se = !backtransf,
  print.tau2 = gs("print.tau2"),
  print.tau = gs("print.tau"),
  print.Q = gs("print.Q"),
  text.tau2 = gs("text.tau2"),
  text.tau = gs("text.tau"),
  details.methods = gs("details"),
  legend = gs("legend"),
  ...
)
}
\arguments{
\item{x}{An object of class \code{netmeta} (or \code{subgroup.netmeta}).}

\item{subgroup}{A vector defining the subgroups considered in the
network meta-analysis.}

\item{only.connected}{A logical indicating whether networks of subgroups
must be connected.}

\item{common}{A logical indicating whether results for common
effect subgroup network meta-analysis should be printed.}

\item{random}{A logical indicating whether results for random
effects subgroup network meta-analysis should be printed.}

\item{method.tau}{A character string indicating which method is
used to estimate the between-study variance \eqn{\tau^2} and its
square root \eqn{\tau}. Either \code{"DL"}, \code{"REML"}, or
\code{"ML"}, can be abbreviated.}

\item{level.ma}{The level used to calculate confidence intervals
for network estimates.}

\item{backtransf}{A logical indicating whether results should be
back transformed in printouts and forest plots. If
\code{backtransf = TRUE}, results for \code{sm = "OR"} are
presented as odds ratios rather than log odds ratios, for
example.}

\item{nchar.trts}{A numeric defining the minimum number of
characters used to create unique treatment names
(see \code{\link{netmeta}}).}

\item{\dots}{Additional arguments.}

\item{digits}{Minimal number of significant digits, see
\code{print.default}.}

\item{digits.se}{Minimal number of significant digits for standard
errors.}

\item{digits.Q}{Minimal number of significant digits for
heterogeneity statistic Q, see \code{print.default}.}

\item{digits.pval.Q}{Minimal number of significant digits for
p-value of heterogeneity test, see \code{print.default}.}

\item{digits.tau2}{Minimal number of significant digits for
between-study variance \eqn{\tau^2}, see \code{print.default}.}

\item{digits.tau}{Minimal number of significant digits for
\eqn{\tau}, the square root of the between-study variance
\eqn{\tau^2}.}

\item{big.mark}{A character used as thousands separator.}

\item{scientific.pval}{A logical specifying whether p-values should
be printed in scientific notation, e.g., 1.2345e-01 instead of
0.12345.}

\item{zero.pval}{A logical specifying whether p-values should be
printed with a leading zero.}

\item{JAMA.pval}{A logical specifying whether p-values for test of
overall effect should be printed according to JAMA reporting
standards.}

\item{print.se}{A logical specifying whether standard errors should be
printed.}

\item{print.tau2}{A logical specifying whether between-study
variance \eqn{\tau^2} should be printed.}

\item{print.tau}{A logical specifying whether \eqn{\tau}, the
square root of the between-study variance \eqn{\tau^2}, should be
printed.}

\item{print.Q}{A logical value indicating whether to print the
results of the test of heterogeneity.}

\item{text.tau2}{Text printed to identify between-study variance
\eqn{\tau^2}.}

\item{text.tau}{Text printed to identify \eqn{\tau}, the square
root of the between-study variance \eqn{\tau^2}.}

\item{details.methods}{A logical specifying whether details on statistical
methods should be printed.}

\item{legend}{A logical indicating whether a legend should be
printed.}
}
\value{
An object of class \code{"subgroup.netmeta"} with corresponding \code{print}
  and \code{forest} function.
}
\description{
Subgroup analysis for objects of class \code{netmeta}.
}
\examples{
\donttest{
data("Senn2013")
# Add variable with (fictitious) risk of bias values
Senn2013$rob <- NA
set.seed(1909)
for (i in unique(Senn2013$studlab))
  Senn2013$rob[Senn2013$studlab == i] <- sample(1:3, 1)
Senn2013$rob <- factor(Senn2013$rob, levels = 1:3,
  labels = c("low", "moderate", "high"))
# Conduct network meta-analysis
net <- netmeta(TE, seTE, treat1.long, treat2.long, studlab,
  data = Senn2013, sm = "MD", reference = "plac", nchar.trts = 4)
# Conduct subgroup network meta-analysis
subgroup(net, rob, common = FALSE)
}

}
\seealso{
\code{\link{forest.subgroup.netmeta}}, \code{\link{forest.netmeta}}
}
